/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.scheduler;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FoliaRunnable
implements Runnable {
    private ScheduledTask task;
    @Nullable
    private AsyncScheduler asyncScheduler;
    @Nullable
    private TimeUnit timeUnit;
    @Nullable
    private EntityScheduler entityScheduler;
    @Nullable
    private Runnable entityRetired;
    @Nullable
    private GlobalRegionScheduler globalRegionScheduler;
    @Nullable
    private RegionScheduler regionScheduler;
    @Nullable
    private Location location;
    @Nullable
    private World world;
    private int chunkX;
    private int chunkZ;

    public FoliaRunnable(@NotNull AsyncScheduler scheduler, @Nullable TimeUnit timeUnit) {
        this.asyncScheduler = scheduler;
        this.timeUnit = timeUnit;
    }

    public FoliaRunnable(@NotNull EntityScheduler scheduler, @Nullable Runnable retired) {
        this.entityScheduler = scheduler;
        this.entityRetired = retired;
    }

    public FoliaRunnable(@NotNull GlobalRegionScheduler scheduler) {
        this.globalRegionScheduler = scheduler;
    }

    public FoliaRunnable(@NotNull RegionScheduler scheduler, @Nullable Location location) {
        this.regionScheduler = scheduler;
        this.location = location;
    }

    public FoliaRunnable(@NotNull RegionScheduler scheduler, @Nullable World world, int chunkX, int chunkZ) {
        this.regionScheduler = scheduler;
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public boolean isCancelled() throws IllegalStateException {
        this.checkScheduled();
        return this.task.isCancelled();
    }

    public void cancel() throws IllegalStateException {
        this.task.cancel();
    }

    @NotNull
    public ScheduledTask run(@NotNull Plugin plugin) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        if (this.globalRegionScheduler != null) {
            return this.setupTask(this.globalRegionScheduler.run(plugin, scheduledTask -> this.run()));
        }
        if (this.entityScheduler != null) {
            return this.setupTask(this.entityScheduler.run(plugin, scheduledTask -> this.run(), this.entityRetired));
        }
        if (this.regionScheduler != null) {
            if (this.location != null) {
                return this.setupTask(this.regionScheduler.run(plugin, this.location, scheduledTask -> this.run()));
            }
            if (this.world != null) {
                return this.setupTask(this.regionScheduler.run(plugin, this.world, this.chunkX, this.chunkZ, scheduledTask -> this.run()));
            }
            throw new UnsupportedOperationException("The region type is not supported.");
        }
        if (this.asyncScheduler != null) {
            return this.setupTask(this.asyncScheduler.runNow(plugin, scheduledTask -> this.run()));
        }
        throw new UnsupportedOperationException("The task type is not supported.");
    }

    @NotNull
    public ScheduledTask runDelayed(@NotNull Plugin plugin, long delay) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        delay = Math.max(1L, delay);
        if (this.globalRegionScheduler != null) {
            return this.setupTask(this.globalRegionScheduler.runDelayed(plugin, scheduledTask -> this.run(), delay));
        }
        if (this.entityScheduler != null) {
            return this.setupTask(this.entityScheduler.runDelayed(plugin, scheduledTask -> this.run(), this.entityRetired, delay));
        }
        if (this.regionScheduler != null) {
            if (this.location != null) {
                return this.setupTask(this.regionScheduler.runDelayed(plugin, this.location, scheduledTask -> this.run(), delay));
            }
            if (this.world != null) {
                return this.setupTask(this.regionScheduler.runDelayed(plugin, this.world, this.chunkX, this.chunkZ, scheduledTask -> this.run(), delay));
            }
            throw new UnsupportedOperationException("The region type is not supported.");
        }
        if (this.asyncScheduler != null && this.timeUnit != null) {
            return this.setupTask(this.asyncScheduler.runDelayed(plugin, scheduledTask -> this.run(), delay, this.timeUnit));
        }
        throw new UnsupportedOperationException("The task type is not supported.");
    }

    public ScheduledTask runAtFixedRate(@NotNull Plugin plugin, long delay, long period) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        delay = Math.max(1L, delay);
        period = Math.max(1L, period);
        if (this.globalRegionScheduler != null) {
            return this.setupTask(this.globalRegionScheduler.runAtFixedRate(plugin, scheduledTask -> this.run(), delay, period));
        }
        if (this.entityScheduler != null) {
            return this.setupTask(this.entityScheduler.runAtFixedRate(plugin, scheduledTask -> this.run(), this.entityRetired, delay, period));
        }
        if (this.regionScheduler != null) {
            if (this.location != null) {
                return this.setupTask(this.regionScheduler.runAtFixedRate(plugin, this.location, scheduledTask -> this.run(), delay, period));
            }
            if (this.world != null) {
                return this.setupTask(this.regionScheduler.runAtFixedRate(plugin, this.world, this.chunkX, this.chunkZ, scheduledTask -> this.run(), delay, period));
            }
            throw new UnsupportedOperationException("The region type is not supported.");
        }
        if (this.asyncScheduler != null && this.timeUnit != null) {
            return this.setupTask(this.asyncScheduler.runAtFixedRate(plugin, scheduledTask -> this.run(), delay, period, this.timeUnit));
        }
        throw new UnsupportedOperationException("The task type is not supported.");
    }

    public int getTaskId() throws IllegalStateException {
        this.checkScheduled();
        return this.task.hashCode();
    }

    private void checkScheduled() {
        if (this.task == null) {
            throw new IllegalStateException("Not scheduled yet");
        }
    }

    private void checkNotYetScheduled() {
        if (this.task != null) {
            throw new IllegalStateException("Already scheduled as " + this.task.hashCode());
        }
    }

    @NotNull
    private ScheduledTask setupTask(ScheduledTask task) {
        this.task = task;
        return task;
    }
}

