/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.listeners;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.MenuManager;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.enums.Scrolls;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.Enchant;
import com.badbones69.crazyenchantments.paper.api.objects.CEBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.enchants.EnchantmentType;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.api.utils.NumberUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.controllers.settings.ProtectionCrystalSettings;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang.WordUtils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;

public class ScrollListener
implements Listener {
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final Starter starter = this.plugin.getStarter();
    private final Methods methods = this.starter.getMethods();
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private String suffix;
    private boolean countVanillaEnchantments;
    private boolean useSuffix;
    private boolean blackScrollChanceToggle;
    private int blackScrollChance;

    public void loadScrollControl() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        this.suffix = config.getString("Settings.TransmogScroll.Amount-of-Enchantments", " &7[&6&n%amount%&7]");
        this.countVanillaEnchantments = config.getBoolean("Settings.TransmogScroll.Count-Vanilla-Enchantments");
        this.useSuffix = config.getBoolean("Settings.TransmogScroll.Amount-Toggle");
        this.blackScrollChance = config.getInt("Settings.BlackScroll.Chance", 75);
        this.blackScrollChanceToggle = config.getBoolean("Settings.BlackScroll.Chance-Toggle");
    }

    @EventHandler(ignoreCancelled=true)
    public void onScrollUse(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        ItemStack scroll = event.getCursor();
        if (item == null || item.getType().isAir() || scroll.getType().isAir()) {
            return;
        }
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType != InventoryType.SlotType.ARMOR && slotType != InventoryType.SlotType.CONTAINER && slotType != InventoryType.SlotType.QUICKBAR) {
            return;
        }
        Scrolls type = Scrolls.getFromPDC(scroll);
        if (type == null) {
            return;
        }
        if (scroll.getAmount() > 1) {
            player.sendMessage(Messages.NEED_TO_UNSTACK_ITEM.getMessage());
            return;
        }
        switch (type.getConfigName()) {
            case "BlackScroll": {
                if (this.methods.isInventoryFull(player)) {
                    return;
                }
                List<CEnchantment> enchantments = this.enchantmentBookSettings.getEnchantmentsOnItem(item);
                if (enchantments.isEmpty()) break;
                event.setCancelled(true);
                player.setItemOnCursor(this.methods.removeItem(scroll));
                if (this.blackScrollChanceToggle && !this.methods.randomPicker(this.blackScrollChance, 100)) {
                    player.sendMessage(Messages.BLACK_SCROLL_UNSUCCESSFUL.getMessage());
                    return;
                }
                Random random = new Random();
                CEnchantment enchantment = enchantments.get(random.nextInt(enchantments.size()));
                player.getInventory().addItem(new ItemStack[]{new CEBook(enchantment, this.enchantmentBookSettings.getLevel(item, enchantment), 1).buildBook()});
                event.setCurrentItem(this.enchantmentBookSettings.removeEnchantment(item, enchantment));
                break;
            }
            case "WhiteScroll": {
                if (Scrolls.hasWhiteScrollProtection(item)) {
                    return;
                }
                for (EnchantmentType enchantmentType : MenuManager.getEnchantmentTypes()) {
                    if (!enchantmentType.getEnchantableMaterials().contains(item.getType())) continue;
                    event.setCancelled(true);
                    event.setCurrentItem(Scrolls.addWhiteScrollProtection(item));
                    player.setItemOnCursor(this.methods.removeItem(scroll));
                    return;
                }
                break;
            }
            case "TransmogScroll": {
                if (this.enchantmentBookSettings.getEnchantments(item).isEmpty()) {
                    return;
                }
                if (item.lore() == null) {
                    return;
                }
                ItemStack orderedItem = this.newOrderNewEnchantments(item.clone());
                if (item.isSimilar(orderedItem)) {
                    return;
                }
                event.setCancelled(true);
                event.setCurrentItem(orderedItem);
                player.setItemOnCursor(this.methods.removeItem(scroll));
            }
        }
    }

    @EventHandler
    public void onScrollClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.checkScroll(player.getInventory().getItemInMainHand(), player, event)) {
            return;
        }
        this.checkScroll(player.getInventory().getItemInOffHand(), player, event);
    }

    private boolean checkScroll(ItemStack scroll, Player player, PlayerInteractEvent event) {
        if (scroll.isEmpty() || !scroll.hasItemMeta()) {
            return false;
        }
        PersistentDataContainer container = scroll.getItemMeta().getPersistentDataContainer();
        if (!container.has(DataKeys.scroll.getNamespacedKey())) {
            return false;
        }
        String data = (String)container.get(DataKeys.scroll.getNamespacedKey(), PersistentDataType.STRING);
        assert (data != null);
        if (data.equalsIgnoreCase(Scrolls.BLACK_SCROLL.getConfigName())) {
            event.setCancelled(true);
            player.sendMessage(Messages.RIGHT_CLICK_BLACK_SCROLL.getMessage());
            return true;
        }
        if (data.equalsIgnoreCase(Scrolls.WHITE_SCROLL.getConfigName()) || data.equalsIgnoreCase(Scrolls.TRANSMOG_SCROLL.getConfigName())) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    @Deprecated
    private ItemStack orderNewEnchantments(ItemStack item) {
        HashMap<CEnchantment, Integer> enchantmentLevels = new HashMap<CEnchantment, Integer>();
        HashMap<CEnchantment, Integer> categories = new HashMap<CEnchantment, Integer>();
        ArrayList<CEnchantment> newEnchantmentOrder = new ArrayList<CEnchantment>();
        for (Map.Entry<CEnchantment, Integer> enchantment2 : this.enchantmentBookSettings.getEnchantments(item).entrySet()) {
            enchantmentLevels.put(enchantment2.getKey(), enchantment2.getValue());
            categories.put(enchantment2.getKey(), EnchantUtils.getHighestEnchantmentCategory(enchantment2.getKey()).getRarity());
            newEnchantmentOrder.add(enchantment2.getKey());
        }
        this.orderInts(newEnchantmentOrder, categories);
        ItemMeta newMeta = item.getItemMeta();
        ArrayList newLore = new ArrayList();
        newEnchantmentOrder.forEach(enchantment -> newLore.add(ColorUtils.legacyTranslateColourCodes(enchantment.getCustomName() + " " + NumberUtils.convertLevelString((Integer)enchantmentLevels.get(enchantment)))));
        newMeta.lore(newLore);
        this.useSuffix(item, newMeta, newEnchantmentOrder);
        item.setItemMeta(newMeta);
        return item;
    }

    private ItemStack newOrderNewEnchantments(ItemStack item) {
        Gson gson = new Gson();
        ItemMeta meta = item.getItemMeta();
        List lore = item.lore();
        assert (meta != null && lore != null);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Enchant data = (Enchant)gson.fromJson((String)container.get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING), Enchant.class);
        boolean addSpaces = FileManager.Files.CONFIG.getFile().getBoolean("Settings.TransmogScroll.Add-Blank-Lines", true);
        ArrayList<CEnchantment> newEnchantmentOrder = new ArrayList<CEnchantment>();
        HashMap<CEnchantment, Integer> enchantments = new HashMap<CEnchantment, Integer>();
        List<String> order = FileManager.Files.CONFIG.getFile().getStringList("Settings.TransmogScroll.Lore-Order");
        if (order.isEmpty()) {
            order = Arrays.asList("CE_Enchantments", "Protection", "Normal_Lore");
        }
        if (data == null) {
            return item;
        }
        for (CEnchantment enchantment : this.enchantmentBookSettings.getRegisteredEnchantments()) {
            if (!data.hasEnchantment(enchantment.getName())) continue;
            enchantments.put(enchantment, ColorUtils.stripStringColour(enchantment.getCustomName() + " " + NumberUtils.toRoman(data.getLevel(enchantment.getName()))).length());
            newEnchantmentOrder.add(enchantment);
        }
        this.orderInts(newEnchantmentOrder, enchantments);
        List enchantLore = newEnchantmentOrder.stream().map(i -> ColorUtils.legacyTranslateColourCodes("%s %s".formatted(i.getCustomName(), NumberUtils.toRoman(data.getLevel(i.getName()))))).collect(Collectors.toList());
        List<Component> normalLore = this.stripNonNormalLore(lore, newEnchantmentOrder);
        List<Component> protectionLore = this.getAllProtectionLore(container);
        ArrayList<Object> newLore = new ArrayList<Object>();
        boolean wasEmpty = true;
        Iterator<String> iterator = order.iterator();
        while (iterator.hasNext()) {
            String selection;
            switch (selection = iterator.next()) {
                case "CE_Enchantments": {
                    if (addSpaces && !wasEmpty && !enchantLore.isEmpty()) {
                        newLore.add(Component.text((String)""));
                    }
                    newLore.addAll(enchantLore);
                    wasEmpty = enchantLore.isEmpty();
                    break;
                }
                case "Protection": {
                    if (addSpaces && !wasEmpty && !protectionLore.isEmpty()) {
                        newLore.add(Component.text((String)""));
                    }
                    newLore.addAll(protectionLore);
                    wasEmpty = protectionLore.isEmpty();
                    break;
                }
                case "Normal_Lore": {
                    if (addSpaces && !wasEmpty && !normalLore.isEmpty()) {
                        newLore.add(Component.text((String)""));
                    }
                    newLore.addAll(normalLore);
                    wasEmpty = normalLore.isEmpty();
                }
            }
        }
        this.useSuffix(item, meta, newEnchantmentOrder);
        meta.lore(newLore);
        item.setItemMeta(meta);
        return item;
    }

    private List<Component> getAllProtectionLore(PersistentDataContainer container) {
        ArrayList<Component> lore = new ArrayList<Component>();
        if (Scrolls.hasWhiteScrollProtection(container)) {
            lore.add((Component)ColorUtils.legacyTranslateColourCodes(FileManager.Files.CONFIG.getFile().getString("Settings.WhiteScroll.ProtectedName")));
        }
        if (ProtectionCrystalSettings.isProtected(container)) {
            lore.add((Component)ColorUtils.legacyTranslateColourCodes(FileManager.Files.CONFIG.getFile().getString("Settings.ProtectionCrystal.Protected")));
        }
        return lore;
    }

    private List<Component> stripNonNormalLore(List<Component> lore, List<CEnchantment> enchantments) {
        lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).replaceAll(" ", "").isEmpty());
        enchantments.forEach(enchant -> lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(enchant.getCustomName()))));
        lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(Scrolls.getWhiteScrollProtectionName())));
        lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(FileManager.Files.CONFIG.getFile().getString("Settings.ProtectionCrystal.Protected"))));
        return lore;
    }

    private void useSuffix(ItemStack item, ItemMeta meta, List<CEnchantment> newEnchantmentOrder) {
        if (this.useSuffix) {
            String newName;
            String string = newName = meta.hasDisplayName() ? ColorUtils.toLegacy(meta.displayName()) : "&b" + WordUtils.capitalizeFully((String)item.getType().toString().replace("_", " "));
            if (meta.hasDisplayName()) {
                for (int i = 0; i <= 100; ++i) {
                    String suffixWithAmount = this.suffix.replace("%Amount%", String.valueOf(i)).replace("%amount%", String.valueOf(i));
                    if (!newName.endsWith(suffixWithAmount)) continue;
                    newName = newName.substring(0, newName.length() - suffixWithAmount.length());
                    break;
                }
            }
            String amount = String.valueOf(this.countVanillaEnchantments ? newEnchantmentOrder.size() + item.getEnchantments().size() : newEnchantmentOrder.size());
            meta.displayName((Component)ColorUtils.legacyTranslateColourCodes(newName + this.suffix.replace("%Amount%", amount).replace("%amount%", amount)));
        }
    }

    private void orderInts(List<CEnchantment> list, Map<CEnchantment, Integer> map) {
        list.sort((a1, a2) -> {
            Integer string1 = (Integer)map.get(a1);
            Integer string2 = (Integer)map.get(a2);
            return string2.compareTo(string1);
        });
    }
}

