/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.events.MassBlockBreakEvent;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.anticheats.NoCheatPlusSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PickaxeEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final NoCheatPlusSupport noCheatPlusSupport = this.starter.getNoCheatPlusSupport();
    private final HashMap<Player, HashMap<Block, BlockFace>> blocks = new HashMap();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = this.methods.getItemInHand(player);
        Block block = event.getClickedBlock();
        if (block == null || block.isEmpty() || !this.crazyManager.getBlastBlockList().contains(block.getType())) {
            return;
        }
        if (!EnchantUtils.isMassBlockBreakActive(player, CEnchantments.BLAST, this.enchantmentBookSettings.getEnchantments(item))) {
            return;
        }
        HashMap<Block, BlockFace> blockFace = new HashMap<Block, BlockFace>();
        blockFace.put(block, event.getBlockFace());
        this.blocks.put(player, blockFace);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlastBreak(BlockBreakEvent event) {
        if (!event.isDropItems() || EventUtils.isIgnoredEvent((Event)event)) {
            return;
        }
        Player player = event.getPlayer();
        Block initialBlock = event.getBlock();
        ItemStack currentItem = this.methods.getItemInHand(player);
        boolean damage = FileManager.Files.CONFIG.getFile().getBoolean("Settings.EnchantmentOptions.Blast-Full-Durability");
        if (!this.blocks.containsKey(player) || !this.blocks.get(player).containsKey(initialBlock)) {
            return;
        }
        HashSet<Block> blockList = this.getBlocks(initialBlock.getLocation(), this.blocks.get(player).get(initialBlock), this.enchantmentBookSettings.getLevel(currentItem, CEnchantments.BLAST.getEnchantment()) - 1);
        this.blocks.remove(player);
        if (this.massBlockBreakCheck(player, blockList)) {
            return;
        }
        event.setCancelled(true);
        for (Block block : blockList) {
            if (block.isEmpty() || !this.crazyManager.getBlastBlockList().contains(block.getType()) || this.methods.playerBreakBlock(player, block, currentItem, this.crazyManager.isDropBlocksBlast()) || !damage) continue;
            this.methods.removeDurability(currentItem, player);
        }
        if (!damage) {
            this.methods.removeDurability(currentItem, player);
        }
        this.antiCheat(player);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onVeinMinerBreak(BlockBreakEvent event) {
        if (!this.isOreBlock(event.getBlock().getType()) || !event.isDropItems() || EventUtils.isIgnoredEvent((Event)event)) {
            return;
        }
        Player player = event.getPlayer();
        Block currentBlock = event.getBlock();
        ItemStack currentItem = this.methods.getItemInHand(player);
        Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(currentItem);
        boolean damage = FileManager.Files.CONFIG.getFile().getBoolean("Settings.EnchantmentOptions.VeinMiner-Full-Durability", true);
        if (!EnchantUtils.isMassBlockBreakActive(player, CEnchantments.VEINMINER, enchantments)) {
            return;
        }
        HashSet<Block> blockList = this.getOreBlocks(currentBlock.getLocation(), enchantments.get(CEnchantments.VEINMINER.getEnchantment()));
        blockList.add(currentBlock);
        if (this.massBlockBreakCheck(player, blockList)) {
            return;
        }
        event.setCancelled(true);
        for (Block block : blockList) {
            if (block.isEmpty() || this.methods.playerBreakBlock(player, block, currentItem, this.crazyManager.isDropBlocksVeinMiner()) || !damage) continue;
            this.methods.removeDurability(currentItem, player);
        }
        if (!damage) {
            this.methods.removeDurability(currentItem, player);
        }
        this.antiCheat(player);
    }

    private boolean massBlockBreakCheck(Player player, Set<Block> blockList) {
        MassBlockBreakEvent event = new MassBlockBreakEvent(player, blockList);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }

    private void antiCheat(Player player) {
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDropAlter(BlockDropItemEvent event) {
        if (!this.isOreBlock(event.getBlockState().getType())) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = this.methods.getItemInHand(player);
        Map<CEnchantment, Integer> enchants = this.enchantmentBookSettings.getEnchantments(item);
        List oldDrops = event.getItems();
        if (EnchantUtils.isEventActive(CEnchantments.AUTOSMELT, (Entity)player, item, enchants)) {
            int level = enchants.get(CEnchantments.AUTOSMELT.getEnchantment());
            for (int j = 0; j < oldDrops.size(); ++j) {
                Item entityItem = (Item)oldDrops.get(j);
                ItemStack drop = entityItem.getItemStack();
                int amountToAdd = 0;
                if (!this.isOre(drop.getType())) continue;
                for (int i = 0; i < level; ++i) {
                    if (!CEnchantments.AUTOSMELT.chanceSuccessful(level)) continue;
                    ++amountToAdd;
                }
                drop = this.getOreDrop(drop.getType(), drop.getAmount() + amountToAdd);
                entityItem.setItemStack(drop);
                event.getItems().set(j, entityItem);
            }
            return;
        }
        if (EnchantUtils.isEventActive(CEnchantments.FURNACE, (Entity)player, item, enchants)) {
            for (int j = 0; j < oldDrops.size(); ++j) {
                Item entityItem = (Item)oldDrops.get(j);
                ItemStack drop = entityItem.getItemStack();
                if (!this.isOre(drop.getType())) continue;
                drop = this.getOreDrop(drop.getType(), drop.getAmount());
                entityItem.setItemStack(drop);
                event.getItems().set(j, entityItem);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExperience(BlockBreakEvent event) {
        Map<CEnchantment, Integer> enchants;
        ItemStack item;
        Player player = event.getPlayer();
        if (!EnchantUtils.isEventActive(CEnchantments.EXPERIENCE, (Entity)player, item = this.methods.getItemInHand(player), enchants = this.enchantmentBookSettings.getEnchantments(item))) {
            return;
        }
        event.setExpToDrop(event.getExpToDrop() + (enchants.get(CEnchantments.EXPERIENCE.getEnchantment()) + 2));
    }

    private HashSet<Block> getOreBlocks(Location loc, int amount) {
        HashSet<Block> blocks = new HashSet<Block>(Set.of(loc.getBlock()));
        HashSet<Block> newestBlocks = new HashSet<Block>(Set.of(loc.getBlock()));
        for (int depth = 0; depth < amount; ++depth) {
            HashSet<Block> tempBlocks = new HashSet<Block>();
            for (Block block1 : newestBlocks) {
                for (Block block : this.getSurroundingBlocks(block1.getLocation())) {
                    if (blocks.contains(block) || !this.isOreBlock(block.getType())) continue;
                    tempBlocks.add(block);
                }
            }
            blocks.addAll(tempBlocks);
            newestBlocks = tempBlocks;
        }
        return blocks;
    }

    private HashSet<Block> getSurroundingBlocks(Location loc) {
        HashSet<Block> locations = new HashSet<Block>();
        locations.add(loc.clone().add(0.0, 1.0, 0.0).getBlock());
        locations.add(loc.clone().add(0.0, -1.0, 0.0).getBlock());
        locations.add(loc.clone().add(1.0, 0.0, 0.0).getBlock());
        locations.add(loc.clone().add(-1.0, 0.0, 0.0).getBlock());
        locations.add(loc.clone().add(0.0, 0.0, 1.0).getBlock());
        locations.add(loc.clone().add(0.0, 0.0, -1.0).getBlock());
        return locations;
    }

    private HashSet<Block> getBlocks(Location loc, BlockFace blockFace, Integer depth) {
        Location loc2 = loc.clone();
        switch (blockFace) {
            case SOUTH: {
                loc.add(-1.0, 1.0, (double)(-depth.intValue()));
                loc2.add(1.0, -1.0, 0.0);
                break;
            }
            case WEST: {
                loc.add((double)depth.intValue(), 1.0, -1.0);
                loc2.add(0.0, -1.0, 1.0);
                break;
            }
            case EAST: {
                loc.add((double)(-depth.intValue()), 1.0, 1.0);
                loc2.add(0.0, -1.0, -1.0);
                break;
            }
            case NORTH: {
                loc.add(1.0, 1.0, (double)depth.intValue());
                loc2.add(-1.0, -1.0, 0.0);
                break;
            }
            case UP: {
                loc.add(-1.0, (double)(-depth.intValue()), -1.0);
                loc2.add(1.0, 0.0, 1.0);
                break;
            }
            case DOWN: {
                loc.add(1.0, (double)depth.intValue(), 1.0);
                loc2.add(-1.0, 0.0, -1.0);
                break;
            }
        }
        return this.methods.getEnchantBlocks(loc, loc2);
    }

    private boolean isOre(Material material) {
        return switch (material) {
            case Material.COAL, Material.RAW_COPPER, Material.DIAMOND, Material.EMERALD, Material.RAW_GOLD, Material.RAW_IRON, Material.LAPIS_LAZULI, Material.REDSTONE, Material.GOLD_NUGGET, Material.QUARTZ -> true;
            default -> false;
        };
    }

    private boolean isOreBlock(Material material) {
        return switch (material) {
            case Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.NETHER_GOLD_ORE, Material.NETHER_QUARTZ_ORE -> true;
            default -> false;
        };
    }

    private ItemStack getOreDrop(Material material, int amount) {
        ItemStack item = new ItemStack(switch (material) {
            case Material.COAL -> Material.COAL;
            case Material.RAW_COPPER -> Material.COPPER_INGOT;
            case Material.DIAMOND -> Material.DIAMOND;
            case Material.EMERALD -> Material.EMERALD;
            case Material.RAW_GOLD -> Material.GOLD_INGOT;
            case Material.RAW_IRON -> Material.IRON_INGOT;
            case Material.LAPIS_LAZULI -> Material.LAPIS_LAZULI;
            case Material.REDSTONE -> Material.REDSTONE;
            case Material.GOLD_NUGGET -> Material.GOLD_NUGGET;
            case Material.QUARTZ -> Material.QUARTZ;
            default -> Material.AIR;
        });
        item.setAmount(amount);
        return item;
    }
}

