/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.events.EnchantmentUseEvent;
import com.badbones69.crazyenchantments.paper.api.managers.BowEnchantmentManager;
import com.badbones69.crazyenchantments.paper.api.objects.BowEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.EnchantedArrow;
import com.badbones69.crazyenchantments.paper.api.utils.BowUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import com.badbones69.crazyenchantments.paper.support.anticheats.NoCheatPlusSupport;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class BowEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();
    @NotNull
    private final NoCheatPlusSupport noCheatPlusSupport = this.starter.getNoCheatPlusSupport();
    @NotNull
    private final BowEnchantmentManager bowEnchantmentManager = this.starter.getBowEnchantmentManager();
    @NotNull
    private final BowUtils bowUtils = this.starter.getBowUtils();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBowShoot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player entity = (Player)livingEntity;
        if (EventUtils.isIgnoredEvent((Event)event) || EventUtils.isIgnoredUUID(event.getEntity().getUniqueId())) {
            return;
        }
        Entity entity2 = event.getProjectile();
        if (!(entity2 instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity2;
        ItemStack bow = event.getBow();
        if (!this.bowUtils.allowsCombat((Entity)entity)) {
            return;
        }
        Map<CEnchantment, Integer> enchants = this.enchantmentBookSettings.getEnchantments(bow);
        if (enchants.isEmpty()) {
            return;
        }
        this.bowUtils.addArrow(arrow, bow, enchants);
        if (!enchants.containsKey(CEnchantments.MULTIARROW.getEnchantment())) {
            return;
        }
        int power = enchants.get(CEnchantments.MULTIARROW.getEnchantment());
        EnchantmentUseEvent useEvent = new EnchantmentUseEvent(entity, CEnchantments.MULTIARROW, bow);
        this.plugin.getServer().getPluginManager().callEvent((Event)useEvent);
        if (!useEvent.isCancelled()) {
            for (int i = 1; i <= power; ++i) {
                this.bowUtils.spawnArrows((Entity)entity, (Entity)arrow, bow);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLand(ProjectileHitEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        Arrow entityArrow = (Arrow)projectile;
        if (!this.bowUtils.allowsCombat((Entity)event.getEntity())) {
            return;
        }
        EnchantedArrow arrow = this.bowUtils.getEnchantedArrow(entityArrow);
        if (arrow == null) {
            return;
        }
        this.bowUtils.spawnWebs(event.getHitEntity(), arrow, entityArrow);
        if (EnchantUtils.isEventActive(CEnchantments.BOOM, (Entity)shooter, arrow.bow(), arrow.enchantments())) {
            this.methods.explode(arrow.getShooter(), (Entity)arrow.arrow());
            arrow.arrow().remove();
        }
        if (EnchantUtils.isEventActive(CEnchantments.LIGHTNING, (Entity)shooter, arrow.bow(), arrow.enchantments())) {
            Location location = arrow.arrow().getLocation();
            LightningStrike lightning = location.getWorld().strikeLightningEffect(location);
            int lightningSoundRange = FileManager.Files.CONFIG.getFile().getInt("Settings.EnchantmentOptions.Lightning-Sound-Range", 160);
            try {
                location.getWorld().playSound(location, Sound.ENTITY_LIGHTNING_BOLT_IMPACT, (float)lightningSoundRange / 16.0f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (LivingEntity entity : this.methods.getNearbyLivingEntities(2.0, (Entity)arrow.arrow())) {
                EntityDamageEvent damageByEntityEvent = new EntityDamageEvent((Entity)entity, EntityDamageEvent.DamageCause.LIGHTNING, DamageSource.builder((DamageType)DamageType.LIGHTNING_BOLT).withCausingEntity((Entity)shooter).withDirectEntity((Entity)lightning).build(), 5.0);
                EventUtils.addIgnoredEvent((Event)damageByEntityEvent);
                EventUtils.addIgnoredUUID(shooter.getUniqueId());
                shooter.getServer().getPluginManager().callEvent((Event)damageByEntityEvent);
                if (!(damageByEntityEvent.isCancelled() || this.pluginSupport.isFriendly(arrow.getShooter(), (Entity)entity) || arrow.getShooter().getUniqueId().equals(entity.getUniqueId()))) {
                    entity.damage(5.0);
                }
                EventUtils.removeIgnoredEvent((Event)damageByEntityEvent);
                EventUtils.removeIgnoredUUID(shooter.getUniqueId());
            }
        }
        entityArrow.getScheduler().runDelayed((Plugin)this.plugin, arrowTask -> this.bowUtils.removeArrow(arrow), null, 5L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArrowDamage(EntityDamageByEntityEvent event) {
        if (EventUtils.isIgnoredEvent((Event)event)) {
            return;
        }
        Entity entity = event.getDamager();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow entityArrow = (Arrow)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity3 = (LivingEntity)entity2;
        EnchantedArrow arrow = this.bowUtils.getEnchantedArrow(entityArrow);
        if (arrow == null) {
            return;
        }
        if (!this.pluginSupport.allowCombat(arrow.arrow().getLocation())) {
            return;
        }
        ItemStack bow = arrow.bow();
        if (EnchantUtils.isEventActive(CEnchantments.DOCTOR, arrow.getShooter(), arrow.bow(), arrow.enchantments()) && this.pluginSupport.isFriendly(arrow.getShooter(), event.getEntity())) {
            int heal = 1 + arrow.getLevel(CEnchantments.DOCTOR);
            double maxHealth = entity3.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            if (entity3.getHealth() < maxHealth) {
                if (entity3.getHealth() + (double)heal < maxHealth) {
                    entity3.setHealth(entity3.getHealth() + (double)heal);
                }
                if (entity3.getHealth() + (double)heal >= maxHealth) {
                    entity3.setHealth(maxHealth);
                }
            }
        }
        if (this.pluginSupport.isFriendly(arrow.getShooter(), (Entity)entity3)) {
            return;
        }
        this.bowUtils.spawnWebs(event.getEntity(), arrow, entityArrow);
        if (EnchantUtils.isEventActive(CEnchantments.PULL, arrow.getShooter(), arrow.bow(), arrow.enchantments())) {
            Vector v = arrow.getShooter().getLocation().toVector().subtract(entity3.getLocation().toVector()).normalize().multiply(3);
            entity3.setVelocity(v);
        }
        for (BowEnchantment bowEnchantment : this.bowEnchantmentManager.getBowEnchantments()) {
            CEnchantments enchantment = bowEnchantment.getEnchantment();
            if (!EnchantUtils.isEventActive(enchantment, arrow.getShooter(), arrow.bow(), arrow.enchantments())) continue;
            if (bowEnchantment.isPotionEnchantment()) {
                bowEnchantment.getPotionEffects().forEach(effect -> entity3.addPotionEffect(new PotionEffect(effect.potionEffect(), effect.duration(), (bowEnchantment.isLevelAddedToAmplifier() ? arrow.getLevel(enchantment) : 0) + effect.amplifier())));
                continue;
            }
            event.setDamage(event.getDamage() * ((double)(bowEnchantment.isLevelAddedToAmplifier() ? arrow.getLevel(enchantment) : 0) + bowEnchantment.getDamageAmplifier()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onWebBreak(BlockBreakEvent event) {
        if (!EventUtils.isIgnoredEvent((Event)event) && this.bowUtils.getWebBlocks().contains(event.getBlock())) {
            event.setCancelled(true);
        }
    }
}

