/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EntityUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class AxeEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    @NotNull
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (EventUtils.isIgnoredEvent((Event)event)) {
            return;
        }
        if (this.pluginSupport.isFriendly(event.getDamager(), event.getEntity())) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Entity entity3 = event.getDamager();
        if (!(entity3 instanceof Player)) {
            return;
        }
        Player damager = (Player)entity3;
        ItemStack item = this.methods.getItemInHand(damager);
        if (entity2.isDead()) {
            return;
        }
        Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(item);
        if (EnchantUtils.isEventActive(CEnchantments.BERSERK, (Entity)damager, item, enchantments)) {
            damager.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, (enchantments.get(CEnchantments.BERSERK.getEnchantment()) + 5) * 20, 1));
            damager.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, (enchantments.get(CEnchantments.BERSERK.getEnchantment()) + 5) * 20, 0));
        }
        if (EnchantUtils.isEventActive(CEnchantments.BLESSED, (Entity)damager, item, enchantments)) {
            this.removeBadPotions(damager);
        }
        if (EnchantUtils.isEventActive(CEnchantments.FEEDME, (Entity)damager, item, enchantments) && damager.getFoodLevel() < 20) {
            int food = 2 * enchantments.get(CEnchantments.FEEDME.getEnchantment());
            if (damager.getFoodLevel() + food < 20) {
                damager.setFoodLevel((int)(damager.getSaturation() + (float)food));
            }
            if (damager.getFoodLevel() + food > 20) {
                damager.setFoodLevel(20);
            }
        }
        if (EnchantUtils.isEventActive(CEnchantments.REKT, (Entity)damager, item, enchantments)) {
            event.setDamage(event.getDamage() * 2.0);
        }
        if (EnchantUtils.isEventActive(CEnchantments.CURSED, (Entity)damager, item, enchantments)) {
            entity2.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, (enchantments.get(CEnchantments.CURSED.getEnchantment()) + 9) * 20, 1));
        }
        if (EnchantUtils.isEventActive(CEnchantments.DIZZY, (Entity)damager, item, enchantments)) {
            entity2.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, (enchantments.get(CEnchantments.DIZZY.getEnchantment()) + 9) * 20, 0));
        }
        if (EnchantUtils.isEventActive(CEnchantments.BATTLECRY, (Entity)damager, item, enchantments)) {
            for (Entity nearbyEntity : damager.getNearbyEntities(3.0, 3.0, 3.0)) {
                entity2.getScheduler().run((Plugin)this.plugin, task -> {
                    if (!this.pluginSupport.isFriendly((Entity)damager, nearbyEntity)) {
                        Vector vector = damager.getLocation().toVector().normalize().setY(0.5);
                        Vector vector1 = nearbyEntity.getLocation().toVector().subtract(vector);
                        nearbyEntity.setVelocity(vector1);
                    }
                }, null);
            }
        }
        if (EnchantUtils.isEventActive(CEnchantments.DEMONFORGED, (Entity)damager, item, enchantments) && entity2 instanceof Player) {
            Player player = (Player)entity2;
            ItemStack armorItem = switch (this.methods.percentPick(4, 0)) {
                case 1 -> player.getEquipment().getHelmet();
                case 2 -> player.getEquipment().getChestplate();
                case 3 -> player.getEquipment().getLeggings();
                default -> player.getEquipment().getBoots();
            };
            this.methods.removeDurability(armorItem, player);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        ItemStack item;
        Player player = event.getEntity();
        if (player.getKiller() == null) {
            return;
        }
        if (!this.pluginSupport.allowCombat(player.getLocation())) {
            return;
        }
        Player damager = player.getKiller();
        if (EnchantUtils.isEventActive(CEnchantments.DECAPITATION, (Entity)damager, item = this.methods.getItemInHand(damager), this.enchantmentBookSettings.getEnchantments(item))) {
            event.getDrops().add(new ItemBuilder().setMaterial(Material.PLAYER_HEAD).setPlayerName(player.getName()).build());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        double multiplier;
        Player killer = event.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        ItemStack item = this.methods.getItemInHand(killer);
        Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(item);
        Material headMat = EntityUtils.getHeadMaterial((Entity)event.getEntity());
        if (headMat != null && !EventUtils.containsDrop(event, headMat) && (multiplier = this.crazyManager.getDecapitationHeadMap().getOrDefault(headMat, 0.0).doubleValue()) != 0.0 && EnchantUtils.isEventActive(CEnchantments.DECAPITATION, (Entity)killer, item, enchantments, multiplier)) {
            ItemStack head = new ItemBuilder().setMaterial(headMat).build();
            event.getDrops().add(head);
        }
    }

    private void removeBadPotions(Player player) {
        ArrayList<PotionEffectType> bad = new ArrayList<PotionEffectType>(){
            {
                this.add(PotionEffectType.BLINDNESS);
                this.add(PotionEffectType.NAUSEA);
                this.add(PotionEffectType.HUNGER);
                this.add(PotionEffectType.POISON);
                this.add(PotionEffectType.SLOWNESS);
                this.add(PotionEffectType.MINING_FATIGUE);
                this.add(PotionEffectType.WEAKNESS);
                this.add(PotionEffectType.WITHER);
            }
        };
        bad.forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
    }
}

