/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.managers.AllyManager;
import com.badbones69.crazyenchantments.paper.api.objects.AllyMob;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import com.gmail.nossr50.api.PartyAPI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class AllyEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final EnchantmentBookSettings bookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final AllyManager allyManager = this.starter.getAllyManager();
    private final HashMap<UUID, Calendar> allyCoolDown = new HashMap();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAllySpawn(EntityDamageByEntityEvent event) {
        if (EventUtils.isIgnoredEvent((Event)event)) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity = event.getDamager();
            if (entity instanceof LivingEntity) {
                LivingEntity enemy = (LivingEntity)entity;
                if (!this.inCoolDown(player)) {
                    if (enemy instanceof Player) {
                        Arrays.stream(player.getEquipment().getArmorContents()).map(this.bookSettings::getEnchantments).filter(enchants -> !enchants.isEmpty()).forEach(enchants -> this.checkAllyType(enemy, player, (Map<CEnchantment, Integer>)enchants));
                    }
                } else {
                    this.allyManager.setEnemy(player, (Entity)enemy);
                }
            }
        }
        if ((entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity enemy = (LivingEntity)entity;
            entity = event.getDamager();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (this.allyManager.isAlly(player, (Entity)enemy)) {
                    event.setCancelled(true);
                    return;
                }
                if (this.inCoolDown(player)) {
                    this.allyManager.setEnemy(player, (Entity)enemy);
                    return;
                }
                Arrays.stream(player.getEquipment().getArmorContents()).map(this.bookSettings::getEnchantments).filter(enchants -> !enchants.isEmpty()).forEach(enchants -> this.checkAllyType(enemy, player, (Map<CEnchantment, Integer>)enchants));
            }
        }
    }

    private void checkAllyType(LivingEntity enemy, Player player, Map<CEnchantment, Integer> enchants) {
        int power;
        if (enchants.containsKey(CEnchantments.TAMER.getEnchantment())) {
            power = enchants.get(CEnchantments.TAMER.getEnchantment());
            this.spawnAllies(player, enemy, AllyMob.AllyType.WOLF, power);
        }
        if (enchants.containsKey(CEnchantments.GUARDS.getEnchantment())) {
            power = enchants.get(CEnchantments.GUARDS.getEnchantment());
            this.spawnAllies(player, enemy, AllyMob.AllyType.IRON_GOLEM, power);
        }
        if (enchants.containsKey(CEnchantments.BEEKEEPER.getEnchantment())) {
            power = enchants.get(CEnchantments.BEEKEEPER.getEnchantment());
            this.spawnAllies(player, enemy, AllyMob.AllyType.BEE, power);
        }
        if (enchants.containsKey(CEnchantments.NECROMANCER.getEnchantment())) {
            power = enchants.get(CEnchantments.NECROMANCER.getEnchantment());
            this.spawnAllies(player, enemy, AllyMob.AllyType.ZOMBIE, power * 2);
        }
        if (enchants.containsKey(CEnchantments.INFESTATION.getEnchantment())) {
            power = enchants.get(CEnchantments.INFESTATION.getEnchantment());
            this.spawnAllies(player, enemy, AllyMob.AllyType.ENDERMITE, power * 3);
            this.spawnAllies(player, enemy, AllyMob.AllyType.SILVERFISH, power * 3);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onAllyTarget(EntityTargetEvent event) {
        Entity entity;
        if (event.getTarget() == null) {
            return;
        }
        AllyMob allyMob = this.allyManager.getAllyMob(event.getEntity());
        AllyMob target = this.allyManager.getAllyMob(event.getTarget());
        if (allyMob != null && target != null && allyMob.getOwner().getUniqueId() == target.getOwner().getUniqueId()) {
            event.setCancelled(true);
            return;
        }
        if (allyMob != null && target instanceof Player && PluginSupport.SupportedPlugins.MCMMO.isPluginLoaded()) {
            PartyAPI.inSameParty((Player)allyMob.getOwner(), (Player)((Player)target));
        }
        if ((entity = event.getTarget()) instanceof Player) {
            Player player = (Player)entity;
            if (allyMob != null && player.getUniqueId() == allyMob.getOwner().getUniqueId()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onAllyDeath(EntityDeathEvent event) {
        if (!this.allyManager.isAllyMob((Entity)event.getEntity())) {
            return;
        }
        event.setDroppedExp(0);
        event.getDrops().clear();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onAllyDespawn(ChunkUnloadEvent event) {
        if (event.getChunk().getEntities().length < 1) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.allyManager.isAllyMob((Entity)(livingEntity = (LivingEntity)entity))) continue;
            this.allyManager.getAllyMob((Entity)livingEntity).forceRemoveAlly();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerLeave(PlayerQuitEvent event) {
        this.allyManager.forceRemoveAllies(event.getPlayer());
    }

    private void spawnAllies(Player player, LivingEntity enemy, AllyMob.AllyType allyType, int amount) {
        Calendar coolDown = Calendar.getInstance();
        coolDown.add(12, 2);
        this.allyCoolDown.put(player.getUniqueId(), coolDown);
        for (int i = 0; i < amount; ++i) {
            AllyMob ally = new AllyMob(player, allyType);
            ally.spawnAlly(60L);
            ally.attackEnemy(enemy);
        }
    }

    private boolean inCoolDown(Player player) {
        if (this.allyCoolDown.containsKey(player.getUniqueId())) {
            if (Calendar.getInstance().before(this.allyCoolDown.get(player.getUniqueId()))) {
                return true;
            }
            this.allyCoolDown.remove(player.getUniqueId());
        }
        return false;
    }
}

