/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.controllers.settings;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ProtectionCrystalSettings {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final String protectionString = ColorUtils.color(FileManager.Files.CONFIG.getFile().getString("Settings.ProtectionCrystal.Protected"));
    private final HashMap<UUID, List<ItemStack>> crystalItems = new HashMap();
    private ItemBuilder crystal;

    public void loadProtectionCrystal() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        this.crystal = new ItemBuilder().setMaterial(config.getString("Settings.ProtectionCrystal.Item", "EMERALD")).setName(config.getString("Settings.ProtectionCrystal.Name", "Error getting name.")).setLore(config.getStringList("Settings.ProtectionCrystal.Lore")).setGlow(config.getBoolean("Settings.ProtectionCrystal.Glowing", false));
    }

    public ItemStack getCrystals() {
        return this.getCrystals(1);
    }

    public ItemStack getCrystals(int amount) {
        ItemStack item = this.crystal.setAmount(amount).build();
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(DataKeys.protection_crystal.getNamespacedKey(), PersistentDataType.BOOLEAN, (Object)true);
        item.setItemMeta(meta);
        return item;
    }

    public void addPlayer(Player player, List<ItemStack> items) {
        this.crystalItems.put(player.getUniqueId(), items);
    }

    public void removePlayer(Player player) {
        this.crystalItems.remove(player.getUniqueId());
    }

    public boolean containsPlayer(Player player) {
        return this.crystalItems.containsKey(player.getUniqueId());
    }

    public List<ItemStack> getPlayer(Player player) {
        return this.crystalItems.get(player.getUniqueId());
    }

    public HashMap<UUID, List<ItemStack>> getCrystalItems() {
        return this.crystalItems;
    }

    public boolean isProtectionSuccessful(Player player) {
        if (player.hasPermission("crazyenchantments.bypass.protectioncrystal")) {
            return true;
        }
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        if (config.getBoolean("Settings.ProtectionCrystal.Chance.Toggle", false)) {
            return this.methods.randomPicker(config.getInt("Settings.ProtectionCrystal.Chance.Success-Chance", 100), 100);
        }
        return true;
    }

    public static boolean isProtected(ItemStack item) {
        return item.hasItemMeta() && ProtectionCrystalSettings.isProtected(item.getItemMeta());
    }

    public static boolean isProtected(ItemMeta meta) {
        return meta != null && ProtectionCrystalSettings.isProtected(meta.getPersistentDataContainer());
    }

    public static boolean isProtected(PersistentDataContainer data) {
        return data != null && data.has(DataKeys.protected_item.getNamespacedKey());
    }

    public boolean isProtectionCrystal(ItemStack item) {
        return item.getItemMeta().getPersistentDataContainer().has(DataKeys.protection_crystal.getNamespacedKey());
    }

    public ItemStack removeProtection(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta.getPersistentDataContainer().has(DataKeys.protected_item.getNamespacedKey())) {
            meta.getPersistentDataContainer().remove(DataKeys.protected_item.getNamespacedKey());
        }
        if (item.lore() != null) {
            List lore = item.lore();
            assert (lore != null);
            lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(this.protectionString)));
            meta.lore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack addProtection(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        List lore = item.lore() != null ? item.lore() : new ArrayList();
        meta.getPersistentDataContainer().set(DataKeys.protected_item.getNamespacedKey(), PersistentDataType.BOOLEAN, (Object)true);
        assert (lore != null);
        lore.add(ColorUtils.legacyTranslateColourCodes(this.protectionString));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

