/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.controllers.settings;

import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.Enchant;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.EnchantedBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.objects.LostBook;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentBookSettings {
    private ItemBuilder enchantmentBook;
    private final List<Category> categories = Lists.newArrayList();
    private final List<CEnchantment> registeredEnchantments = Lists.newArrayList();
    private final Gson gson = new Gson();

    public boolean useUnsafeEnchantments() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        return config.getBoolean("Settings.EnchantmentOptions.UnSafe-Enchantments");
    }

    @Deprecated(since="1.20.6")
    public boolean hasEnchantment(ItemMeta meta, CEnchantment enchantment) {
        this.getEnchantments(meta);
        PersistentDataContainer data = meta.getPersistentDataContainer();
        if (!data.has(DataKeys.enchantments.getNamespacedKey())) {
            return false;
        }
        String itemData = (String)data.get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING);
        if (itemData == null) {
            return false;
        }
        return ((Enchant)this.gson.fromJson(itemData, Enchant.class)).hasEnchantment(enchantment.getName());
    }

    @Nullable
    public CEBook getCEBook(ItemStack book) {
        if (!book.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = book.getItemMeta();
        if (!meta.getPersistentDataContainer().has(DataKeys.stored_enchantments.getNamespacedKey())) {
            return null;
        }
        EnchantedBook data = (EnchantedBook)this.gson.fromJson((String)meta.getPersistentDataContainer().get(DataKeys.stored_enchantments.getNamespacedKey(), PersistentDataType.STRING), EnchantedBook.class);
        CEnchantment enchantment = null;
        for (CEnchantment enchant : this.getRegisteredEnchantments()) {
            if (!enchant.getName().equalsIgnoreCase(data.getName())) continue;
            enchantment = enchant;
            break;
        }
        return new CEBook(enchantment, data.getLevel(), book.getAmount()).setSuccessRate(data.getSuccessChance()).setDestroyRate(data.getDestroyChance());
    }

    @Nullable
    public ItemStack getNewScrambledBook(ItemStack book) {
        if (!book.hasItemMeta()) {
            return null;
        }
        EnchantedBook data = (EnchantedBook)this.gson.fromJson((String)book.getItemMeta().getPersistentDataContainer().get(DataKeys.stored_enchantments.getNamespacedKey(), PersistentDataType.STRING), EnchantedBook.class);
        CEnchantment enchantment = null;
        int bookLevel = 0;
        for (CEnchantment enchantment1 : this.getRegisteredEnchantments()) {
            if (!enchantment1.getName().equalsIgnoreCase(data.getName())) continue;
            enchantment = enchantment1;
            bookLevel = data.getLevel();
        }
        if (enchantment == null) {
            return null;
        }
        return new CEBook(enchantment, bookLevel, EnchantUtils.getHighestEnchantmentCategory(enchantment)).buildBook();
    }

    public boolean isEnchantmentBook(ItemStack book) {
        if (book == null || book.getItemMeta() == null) {
            return false;
        }
        if (!book.getItemMeta().getPersistentDataContainer().has(DataKeys.stored_enchantments.getNamespacedKey())) {
            return false;
        }
        String dataString = (String)book.getItemMeta().getPersistentDataContainer().get(DataKeys.stored_enchantments.getNamespacedKey(), PersistentDataType.STRING);
        EnchantedBook data = (EnchantedBook)this.gson.fromJson(dataString, EnchantedBook.class);
        for (CEnchantment enchantment : this.getRegisteredEnchantments()) {
            if (!enchantment.getName().equalsIgnoreCase(data.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<CEnchantment> getRegisteredEnchantments() {
        return this.registeredEnchantments;
    }

    public ItemBuilder getNormalBook() {
        return new ItemBuilder(this.enchantmentBook);
    }

    @NotNull
    public ItemStack getEnchantmentBookItem() {
        return new ItemBuilder(this.enchantmentBook).build();
    }

    public void setEnchantmentBook(@NotNull ItemBuilder enchantmentBook) {
        this.enchantmentBook = enchantmentBook;
    }

    @NotNull
    public Map<CEnchantment, Integer> getEnchantments(@Nullable ItemStack item) {
        if (item == null || item.getItemMeta() == null) {
            return Collections.emptyMap();
        }
        return this.getEnchantments(item.getItemMeta());
    }

    @NotNull
    public Map<CEnchantment, Integer> getEnchantments(@Nullable ItemMeta meta) {
        if (meta == null) {
            return Collections.emptyMap();
        }
        return this.getEnchantments(meta.getPersistentDataContainer());
    }

    @NotNull
    public Map<CEnchantment, Integer> getEnchantments(@NotNull PersistentDataContainer container) {
        HashMap<CEnchantment, Integer> enchantments = new HashMap<CEnchantment, Integer>();
        String data = (String)container.get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING);
        if (data == null) {
            return Collections.emptyMap();
        }
        Enchant enchants = (Enchant)this.gson.fromJson(data, Enchant.class);
        if (enchants.isEmpty()) {
            return Collections.emptyMap();
        }
        for (CEnchantment enchantment : this.getRegisteredEnchantments()) {
            if (!enchantment.isActivated() || !enchants.hasEnchantment(enchantment.getName())) continue;
            enchantments.put(enchantment, enchants.getLevel(enchantment.getName()));
        }
        return enchantments;
    }

    @Deprecated(since="1.20", forRemoval=true)
    public List<CEnchantment> getEnchantmentsOnItem(ItemStack item) {
        return new ArrayList<CEnchantment>(this.getEnchantments(item).keySet());
    }

    public int getEnchantmentAmount(@NotNull ItemStack item, boolean includeVanillaEnchantments) {
        int amount = this.getEnchantments(item).size();
        if (includeVanillaEnchantments && item.hasItemMeta() && item.getItemMeta().hasEnchants()) {
            amount += item.getItemMeta().getEnchants().size();
        }
        return amount;
    }

    @NotNull
    public List<Category> getCategories() {
        return this.categories;
    }

    public void populateMaps() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        for (String category : config.getConfigurationSection("Categories").getKeys(false)) {
            String path = "Categories." + category;
            LostBook lostBook = new LostBook(config.getInt(path + ".LostBook.Slot"), config.getBoolean(path + ".LostBook.InGUI"), new ItemBuilder().setMaterial(config.getString(path + ".LostBook.Item", "BOOK")).setPlayerName(config.getString(path + ".LostBook.Player")).setName(config.getString(path + ".LostBook.Name", "Error getting name.")).setLore(config.getStringList(path + ".LostBook.Lore")).setGlow(config.getBoolean(path + ".LostBook.Glowing", true)), config.getInt(path + ".LostBook.Cost"), Currency.getCurrency(config.getString(path + ".LostBook.Currency")), config.getBoolean(path + ".LostBook.FireworkToggle", false), this.getColors(config.getString(path + ".LostBook.FireworkColors", "Red, White, Blue")), config.getBoolean(path + ".LostBook.Sound-Toggle", false), config.getString(path + ".LostBook.Sound", "BLOCK_ANVIL_PLACE"));
            this.categories.add(new Category(category, config.getInt(path + ".Slot"), config.getBoolean(path + ".InGUI", true), new ItemBuilder().setMaterial(config.getString(path + ".Item", ColorUtils.getRandomPaneColor().getName())).setPlayerName(config.getString(path + ".Player")).setName(config.getString(path + ".Name", "Error getting name.")).setLore(config.getStringList(path + ".Lore")).setGlow(config.getBoolean(path + ".Glowing", false)), config.getInt(path + ".Cost"), Currency.getCurrency(config.getString(path + ".Currency")), config.getInt(path + ".Rarity"), lostBook, config.getInt(path + ".EnchOptions.SuccessPercent.Max"), config.getInt(path + ".EnchOptions.SuccessPercent.Min"), config.getInt(path + ".EnchOptions.DestroyPercent.Max"), config.getInt(path + ".EnchOptions.DestroyPercent.Min"), config.getBoolean(path + ".EnchOptions.MaxLvlToggle"), config.getInt(path + ".EnchOptions.LvlRange.Max"), config.getInt(path + ".EnchOptions.LvlRange.Min")));
        }
    }

    @Nullable
    public Category getCategory(String name) {
        for (Category category : this.categories) {
            if (!category.getName().equalsIgnoreCase(name)) continue;
            return category;
        }
        return null;
    }

    private List<Color> getColors(String string) {
        ArrayList<Color> colors = new ArrayList<Color>();
        ColorUtils.color(colors, string);
        return colors;
    }

    public int getLevel(@NotNull ItemStack item, @NotNull CEnchantment enchant) {
        int level;
        String data = (String)item.getItemMeta().getPersistentDataContainer().get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING);
        int n = level = data == null ? 0 : ((Enchant)this.gson.fromJson(data, Enchant.class)).getLevel(enchant.getName());
        if (!this.useUnsafeEnchantments() && level > enchant.getMaxLevel()) {
            level = enchant.getMaxLevel();
        }
        return level;
    }

    @NotNull
    public ItemStack removeEnchantment(@NotNull ItemStack item, @NotNull CEnchantment enchant) {
        if (!item.hasItemMeta()) {
            return item;
        }
        item.setItemMeta(this.removeEnchantment(item.getItemMeta(), enchant));
        return item;
    }

    @NotNull
    public ItemMeta removeEnchantment(@NotNull ItemMeta meta, @NotNull CEnchantment enchant) {
        List lore = meta.lore();
        if (lore != null) {
            lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(enchant.getCustomName())));
            meta.lore(lore);
        }
        Enchant data = meta.getPersistentDataContainer().has(DataKeys.enchantments.getNamespacedKey()) ? (Enchant)this.gson.fromJson((String)meta.getPersistentDataContainer().get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING), Enchant.class) : new Enchant(new HashMap<String, Integer>());
        data.removeEnchantment(enchant.getName());
        if (data.isEmpty()) {
            if (meta.getPersistentDataContainer().has(DataKeys.enchantments.getNamespacedKey())) {
                meta.getPersistentDataContainer().remove(DataKeys.enchantments.getNamespacedKey());
            }
        } else {
            meta.getPersistentDataContainer().set(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING, (Object)this.gson.toJson((Object)data));
        }
        return meta;
    }

    @NotNull
    public ItemMeta removeEnchantments(@NotNull ItemMeta meta, @NotNull List<CEnchantment> enchants) {
        List lore = meta.lore();
        if (lore != null) {
            for (CEnchantment enchant2 : enchants) {
                lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(enchant2.getCustomName())));
                meta.lore(lore);
            }
        }
        Enchant data = meta.getPersistentDataContainer().has(DataKeys.enchantments.getNamespacedKey()) ? (Enchant)this.gson.fromJson((String)meta.getPersistentDataContainer().get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING), Enchant.class) : new Enchant(new HashMap<String, Integer>());
        enchants.forEach(enchant -> data.removeEnchantment(enchant.getName()));
        if (data.isEmpty()) {
            if (meta.getPersistentDataContainer().has(DataKeys.enchantments.getNamespacedKey())) {
                meta.getPersistentDataContainer().remove(DataKeys.enchantments.getNamespacedKey());
            }
        } else {
            meta.getPersistentDataContainer().set(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING, (Object)this.gson.toJson((Object)data));
        }
        return meta;
    }
}

