/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.commands;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.MigrateManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.builders.types.MenuManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.ShopMenu;
import com.badbones69.crazyenchantments.paper.api.builders.types.blacksmith.BlackSmithManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.gkitz.KitsManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.tinkerer.TinkererManager;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.enums.Dust;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.enums.Scrolls;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.Enchant;
import com.badbones69.crazyenchantments.paper.api.managers.ShopManager;
import com.badbones69.crazyenchantments.paper.api.objects.CEBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.objects.enchants.EnchantmentType;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.api.utils.FileUtils;
import com.badbones69.crazyenchantments.paper.api.utils.NumberUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.controllers.settings.ProtectionCrystalSettings;
import com.badbones69.crazyenchantments.paper.listeners.ScramblerListener;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CECommand
implements CommandExecutor {
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final Starter starter = this.plugin.getStarter();
    private final FileManager fileManager = this.starter.getFileManager();
    private final Methods methods = this.starter.getMethods();
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    private final ProtectionCrystalSettings protectionCrystalSettings = this.starter.getProtectionCrystalSettings();
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();
    private final ScramblerListener scramblerListener = this.starter.getScramblerListener();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String commandLabel, String[] args) {
        boolean isPlayer = sender instanceof Player;
        if (args.length == 0) {
            if (!isPlayer) {
                sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                return true;
            }
            if (this.hasPermission(sender, "gui")) {
                Player player = (Player)sender;
                ShopManager shopManager = this.starter.getShopManager();
                player.openInventory(new ShopMenu(player, shopManager.getInventorySize(), shopManager.getInventoryName()).build().getInventory());
            }
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "check-enchants": {
                if (!isPlayer) {
                    return true;
                }
                if (!this.hasPermission(sender, "checkenchants")) {
                    return true;
                }
                if (args.length != 2) {
                    sender.sendMessage("Usage: /ce Check-Enchants <Player>");
                    return true;
                }
                Player target = this.methods.getPlayer(args[1]);
                if (target == null) {
                    sender.sendMessage(Messages.NOT_ONLINE.getMessage());
                    return true;
                }
                this.sendArmorStats(target, (Player)sender);
                return true;
            }
            case "updateenchants": {
                if (!isPlayer) {
                    return true;
                }
                if (!this.hasPermission(sender, "updateenchants")) {
                    return true;
                }
                Gson gson = new Gson();
                Player player = (Player)sender;
                Enchant enchants = new Enchant(null);
                ArrayList<Object> lore = new ArrayList<Object>();
                ItemStack item = player.getInventory().getItemInMainHand();
                if (!item.hasItemMeta() || item.lore() == null) {
                    return true;
                }
                ItemMeta meta = item.getItemMeta();
                if (meta.getPersistentDataContainer().has(DataKeys.enchantments.getNamespacedKey())) {
                    enchants = (Enchant)gson.fromJson((String)meta.getPersistentDataContainer().get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING), Enchant.class);
                }
                for (Component line : meta.lore()) {
                    String strippedName = ColorUtils.toPlainText(line);
                    boolean addedLine = false;
                    for (CEnchantment activeEnchant : this.enchantmentBookSettings.getRegisteredEnchantments()) {
                        if (!strippedName.toLowerCase().contains(ColorUtils.stripStringColour(activeEnchant.getCustomName()).toLowerCase()) && !strippedName.toLowerCase().contains(activeEnchant.getName().toLowerCase())) continue;
                        if (enchants.hasEnchantment(activeEnchant.getName())) break;
                        enchants.addEnchantment(activeEnchant.getName(), NumberUtils.convertLevelInteger(strippedName.split(" ")[strippedName.split(" ").length - 1]));
                        lore.add(ColorUtils.legacyTranslateColourCodes(activeEnchant.getCustomName() + " " + NumberUtils.toRoman(enchants.getLevel(activeEnchant.getName()))));
                        addedLine = true;
                        break;
                    }
                    if (addedLine) continue;
                    lore.add(line);
                }
                meta.lore(lore);
                if (!enchants.isEmpty()) {
                    meta.getPersistentDataContainer().set(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING, (Object)gson.toJson((Object)enchants));
                }
                item.setItemMeta(meta);
                player.getInventory().setItemInMainHand(item);
                return true;
            }
            case "convert": {
                if (this.hasPermission(sender, "convert")) {
                    sender.sendMessage(ColorUtils.color("\n&8&m=======================================================\n&eTrying to update config files.\n&eIf you have any issues, Please contact Discord Support.\n&f&nhttps://discord.gg/crazycrew&r\n&eMake sure to check console for more information.\n&8&m=======================================================\n"));
                    MigrateManager.convert();
                }
                return true;
            }
            case "help": {
                if (this.hasPermission(sender, "access")) {
                    sender.sendMessage(Messages.HELP.getMessage());
                }
                return true;
            }
            case "reload": {
                if (this.hasPermission(sender, "reload")) {
                    this.crazyManager.getCEPlayers().forEach(name -> this.crazyManager.backupCEPlayer(name.getPlayer()));
                    this.fileManager.setup();
                    MenuManager.load();
                    this.crazyManager.load();
                    BlackSmithManager.load();
                    KitsManager.load();
                    sender.sendMessage(Messages.CONFIG_RELOAD.getMessage());
                    this.pluginSupport.updateHooks();
                    FileUtils.loadFiles();
                }
                return true;
            }
            case "limit": {
                if (this.hasPermission(sender, "limit")) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("%bypass%", String.valueOf(sender.hasPermission("crazyenchantments.bypass.limit")));
                    assert (sender instanceof Player);
                    Player player = (Player)sender;
                    ItemStack item = player.getInventory().getItemInMainHand();
                    int limit = this.crazyManager.getPlayerMaxEnchantments(player);
                    int baseLimit = this.crazyManager.getPlayerBaseEnchantments(player);
                    int slotModifier = item.isEmpty() ? 0 : this.crazyManager.getEnchantmentLimiter(item);
                    int canAdd = Math.min(baseLimit - slotModifier, limit);
                    placeholders.put("%limit%", String.valueOf(limit));
                    placeholders.put("%baseLimit%", String.valueOf(baseLimit));
                    placeholders.put("%vanilla%", String.valueOf(this.crazyManager.checkVanillaLimit()));
                    placeholders.put("%item%", String.valueOf(item.isEmpty() ? 0 : this.enchantmentBookSettings.getEnchantmentAmount(item, this.crazyManager.checkVanillaLimit())));
                    placeholders.put("%slotCrystal%", String.valueOf(-slotModifier));
                    placeholders.put("%space%", String.valueOf(canAdd));
                    placeholders.put("%limitSetInConfig%", String.valueOf(this.crazyManager.useConfigLimit()));
                    sender.sendMessage(Messages.LIMIT_COMMAND.getMessage(placeholders));
                }
                return true;
            }
            case "debug": {
                if (this.hasPermission(sender, "debug")) {
                    ArrayList<String> brokenEnchantments = new ArrayList<String>();
                    ArrayList<String> brokenEnchantmentTypes = new ArrayList<String>();
                    for (CEnchantments enchantment : CEnchantments.values()) {
                        if (!FileManager.Files.ENCHANTMENTS.getFile().contains("Enchantments." + enchantment.getName())) {
                            brokenEnchantments.add(enchantment.getName());
                        }
                        if (enchantment.getType() != null) continue;
                        brokenEnchantmentTypes.add(enchantment.getName());
                    }
                    if (brokenEnchantments.isEmpty() && brokenEnchantmentTypes.isEmpty()) {
                        sender.sendMessage(ColorUtils.getPrefix("&aAll enchantments are loaded."));
                    } else {
                        if (!brokenEnchantments.isEmpty()) {
                            int amount = 1;
                            sender.sendMessage(ColorUtils.getPrefix("&cMissing Enchantments:"));
                            sender.sendMessage(ColorUtils.getPrefix("&7These enchantments are broken due to one of the following reasons:"));
                            for (String broke : brokenEnchantments) {
                                sender.sendMessage(ColorUtils.color("&c#" + amount + ": &6" + broke));
                                ++amount;
                            }
                            sender.sendMessage(ColorUtils.color("&7- &cMissing from the Enchantments.yml"));
                            sender.sendMessage(ColorUtils.color("&7- &c<Enchantment Name>: option was changed"));
                            sender.sendMessage(ColorUtils.color("&7- &cYaml format has been broken."));
                        }
                        if (!brokenEnchantmentTypes.isEmpty()) {
                            int i = 1;
                            sender.sendMessage(ColorUtils.getPrefix("&cEnchantments with null types:"));
                            sender.sendMessage(ColorUtils.getPrefix("&7These enchantments are broken due to the enchantment type being null."));
                            for (String broke : brokenEnchantmentTypes) {
                                sender.sendMessage(ColorUtils.color("&c#" + i + ": &6" + broke));
                                ++i;
                            }
                        }
                    }
                    sender.sendMessage(ColorUtils.getPrefix("&cEnchantment Types and amount of items in each:"));
                    MenuManager.getEnchantmentTypes().forEach(type -> sender.sendMessage(ColorUtils.color("&c" + type.getName() + ": &6" + type.getEnchantableMaterials().size())));
                }
                return true;
            }
            case "fix": {
                if (this.hasPermission(sender, "fix")) {
                    ArrayList<CEnchantments> brokenEnchantments = new ArrayList<CEnchantments>();
                    FileConfiguration file = FileManager.Files.ENCHANTMENTS.getFile();
                    for (CEnchantments enchantment : CEnchantments.values()) {
                        if (file.contains("Enchantments." + enchantment.getName())) continue;
                        brokenEnchantments.add(enchantment);
                    }
                    sender.sendMessage(ColorUtils.color("&7Fixed a total of " + brokenEnchantments.size() + " enchantments."));
                    for (CEnchantments enchantment : brokenEnchantments) {
                        String path = "Enchantments." + enchantment.getName();
                        file.set(path + ".Enabled", (Object)true);
                        file.set(path + ".Name", (Object)enchantment.getName());
                        file.set(path + ".Color", (Object)"&7");
                        file.set(path + ".BookColor", (Object)"&b&l");
                        file.set(path + ".MaxPower", (Object)1);
                        file.set(path + ".Enchantment-Type", (Object)enchantment.getType().getName());
                        file.set(path + ".Info.Name", (Object)("&e&l" + enchantment.getName() + " &7(&bI&7)"));
                        file.set(path + ".Info.Description", enchantment.getDescription());
                        ArrayList categories = new ArrayList();
                        this.enchantmentBookSettings.getCategories().forEach(category -> categories.add(category.getName()));
                        file.set(path + ".Categories", categories);
                        FileManager.Files.ENCHANTMENTS.saveFile();
                    }
                }
                return true;
            }
            case "info": {
                if (this.hasPermission(sender, "info")) {
                    if (args.length == 1) {
                        if (!isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        MenuManager.openInfoMenu((Player)sender);
                    } else {
                        EnchantmentType enchantmentType = this.methods.getFromName(args[1]);
                        if (enchantmentType != null) {
                            assert (sender instanceof Player);
                            MenuManager.openInfoMenu((Player)sender, enchantmentType);
                            return true;
                        }
                        CEnchantment enchantment = this.crazyManager.getEnchantmentFromName(args[1]);
                        if (enchantment != null) {
                            sender.sendMessage(enchantment.getInfoName());
                            enchantment.getInfoDescription().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                            return true;
                        }
                        sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                    }
                }
                return true;
            }
            case "spawn": {
                if (this.hasPermission(sender, "spawn")) {
                    if (args.length >= 2) {
                        CEnchantment enchantment = this.crazyManager.getEnchantmentFromName(args[1]);
                        Category category2 = this.enchantmentBookSettings.getCategory(args[1]);
                        Location location = isPlayer ? ((Player)sender).getLocation() : new Location((World)this.plugin.getServer().getWorlds().getFirst(), 0.0, 0.0, 0.0);
                        int level = 1;
                        if (enchantment == null && category2 == null) {
                            sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                            return true;
                        }
                        block78: for (String optionString : args) {
                            try {
                                String option = optionString.split(":")[0];
                                String value = optionString.split(":")[1];
                                boolean isInt = NumberUtils.isInt(value);
                                switch (option.toLowerCase()) {
                                    case "level": {
                                        if (isInt) {
                                            level = Integer.parseInt(value);
                                            break;
                                        }
                                        if (!value.contains("-")) break;
                                        level = this.methods.getRandomNumber(value);
                                        break;
                                    }
                                    case "world": {
                                        World world = this.plugin.getServer().getWorld(value);
                                        if (world == null) continue block78;
                                        location.setWorld(world);
                                        break;
                                    }
                                    case "x": {
                                        if (!isInt) break;
                                        location.setX((double)Integer.parseInt(value));
                                        break;
                                    }
                                    case "y": {
                                        if (!isInt) break;
                                        location.setY((double)Integer.parseInt(value));
                                        break;
                                    }
                                    case "z": {
                                        if (!isInt) break;
                                        location.setZ((double)Integer.parseInt(value));
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        location.getWorld().dropItemNaturally(location, category2 == null ? new CEBook(enchantment, level).buildBook() : category2.getLostBook().getLostBook(category2).build());
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("%World%", location.getWorld().getName());
                        placeholders.put("%X%", String.valueOf(location.getBlockX()));
                        placeholders.put("%Y%", String.valueOf(location.getBlockY()));
                        placeholders.put("%Z%", String.valueOf(location.getBlockZ()));
                        sender.sendMessage(Messages.SPAWNED_BOOK.getMessage(placeholders));
                        return true;
                    }
                    sender.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&c/ce Spawn <Enchantment/Category> [(Level:#/Min-Max)/World:<World>/X:#/Y:#/Z:#]"));
                }
                return true;
            }
            case "give": {
                if (!this.hasPermission(sender, "give")) {
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&c/ce give <Player> <itemString>"));
                    return true;
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    sb.append(args[i]).append(" ");
                }
                Player target = this.methods.getPlayer(args[1]);
                if (target == null) {
                    sender.sendMessage(Messages.NOT_ONLINE.getMessage());
                    return true;
                }
                ItemStack item = ItemBuilder.convertString(sb.toString()).build();
                if (item == null) {
                    sender.sendMessage(Messages.INVALID_ITEM_STRING.getMessage());
                    return true;
                }
                this.methods.addItemToInventory(target, item);
                return true;
            }
            case "bottle": {
                if (!this.hasPermission(sender, "give")) {
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&c/ce bottle <Player> <storedAmount> <Amount>"));
                    return true;
                }
                if (!this.checkInt(sender, args[2])) {
                    return true;
                }
                Player target = this.methods.getPlayer(args[1]);
                ItemStack item = TinkererManager.getXPBottle(args[2], FileManager.Files.TINKER.getFile());
                int amount = args.length == 4 && NumberUtils.isInt(args[3]) ? Integer.parseInt(args[3]) : 1;
                item.setAmount(amount);
                if (target == null) {
                    sender.sendMessage(Messages.NOT_ONLINE.getMessage());
                    return true;
                }
                if (item.isEmpty()) {
                    return true;
                }
                this.methods.addItemToInventory(target, item);
                return true;
            }
            case "lostbook": 
            case "lb": {
                if (this.hasPermission(sender, "lostbook")) {
                    if (args.length >= 2) {
                        Player player;
                        if (args.length <= 3 && !isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        int amount = 1;
                        Category category3 = this.enchantmentBookSettings.getCategory(args[1]);
                        if (args.length >= 3) {
                            if (!this.checkInt(sender, args[2])) {
                                return true;
                            }
                            amount = Integer.parseInt(args[2]);
                        }
                        if (args.length >= 4) {
                            if (!this.methods.isPlayerOnline(args[3], sender)) {
                                return true;
                            }
                            player = this.methods.getPlayer(args[3]);
                        } else {
                            player = (Player)sender;
                        }
                        if (category3 != null) {
                            this.methods.addItemToInventory(player, category3.getLostBook().getLostBook(category3, amount).build());
                            return true;
                        }
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("%Category%", args[1]);
                        sender.sendMessage(Messages.NOT_A_CATEGORY.getMessage(placeholders));
                        return true;
                    }
                    sender.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&c/ce LostBook <Category> [Amount] [Player]"));
                }
                return true;
            }
            case "scrambler": 
            case "s": {
                if (this.hasPermission(sender, "scrambler")) {
                    Player player;
                    int amount = 1;
                    if (args.length <= 2 && !isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        if (!this.checkInt(sender, args[1])) {
                            return true;
                        }
                        amount = Integer.parseInt(args[1]);
                    }
                    if (args.length >= 3) {
                        if (!this.methods.isPlayerOnline(args[2], sender)) {
                            return true;
                        }
                        player = this.methods.getPlayer(args[2]);
                    } else {
                        player = (Player)sender;
                    }
                    if (this.methods.isInventoryFull(player)) {
                        return true;
                    }
                    this.methods.addItemToInventory(player, this.scramblerListener.getScramblers(amount));
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("%Amount%", String.valueOf(amount));
                    placeholders.put("%Player%", player.getName());
                    sender.sendMessage(Messages.GIVE_SCRAMBLER_CRYSTAL.getMessage(placeholders));
                    player.sendMessage(Messages.GET_SCRAMBLER.getMessage(placeholders));
                }
                return true;
            }
            case "crystal": 
            case "c": {
                if (this.hasPermission(sender, "crystal")) {
                    Player player;
                    int amount = 1;
                    if (args.length <= 2 && !isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        if (!this.checkInt(sender, args[1])) {
                            return true;
                        }
                        amount = Integer.parseInt(args[1]);
                    }
                    if (args.length >= 3) {
                        if (!this.methods.isPlayerOnline(args[2], sender)) {
                            return true;
                        }
                        player = this.methods.getPlayer(args[2]);
                    } else {
                        player = (Player)sender;
                    }
                    if (this.methods.isInventoryFull(player)) {
                        return true;
                    }
                    this.methods.addItemToInventory(player, this.protectionCrystalSettings.getCrystals(amount));
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("%Amount%", String.valueOf(amount));
                    placeholders.put("%Player%", player.getName());
                    sender.sendMessage(Messages.GIVE_PROTECTION_CRYSTAL.getMessage(placeholders));
                    player.sendMessage(Messages.GET_PROTECTION_CRYSTAL.getMessage(placeholders));
                }
                return true;
            }
            case "slotcrystal": 
            case "sc": {
                if (this.hasPermission(sender, "slotcrystal")) {
                    Player player;
                    int amount = 1;
                    if (args.length <= 2 && !isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        if (!this.checkInt(sender, args[1])) {
                            return true;
                        }
                        amount = Integer.parseInt(args[1]);
                    }
                    if (args.length >= 3) {
                        if (!this.methods.isPlayerOnline(args[2], sender)) {
                            return true;
                        }
                        player = this.methods.getPlayer(args[2]);
                    } else {
                        player = (Player)sender;
                    }
                    if (this.methods.isInventoryFull(player)) {
                        return true;
                    }
                    ItemStack item = this.starter.getSlotCrystalListener().getSlotCrystal();
                    item.setAmount(amount);
                    this.methods.addItemToInventory(player, item);
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("%Amount%", String.valueOf(amount));
                    placeholders.put("%Player%", player.getName());
                    sender.sendMessage(Messages.GIVE_SLOT_CRYSTAL.getMessage(placeholders));
                    player.sendMessage(Messages.GET_SLOT_CRYSTAL.getMessage(placeholders));
                }
                return true;
            }
            case "dust": {
                if (this.hasPermission(sender, "dust")) {
                    if (args.length >= 2) {
                        Dust dust;
                        Player player;
                        int amount = 1;
                        int percent = 0;
                        if (args.length == 2 && !isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        if (args.length >= 3) {
                            if (!this.checkInt(sender, args[2])) {
                                return true;
                            }
                            amount = Integer.parseInt(args[2]);
                        }
                        if (args.length >= 4) {
                            if (!this.methods.isPlayerOnline(args[3], sender)) {
                                return true;
                            }
                            player = this.methods.getPlayer(args[3]);
                        } else {
                            if (!isPlayer) {
                                sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                                return true;
                            }
                            player = (Player)sender;
                        }
                        if (args.length >= 5) {
                            if (!this.checkInt(sender, args[4])) {
                                return true;
                            }
                            percent = Integer.parseInt(args[4]);
                        }
                        if ((dust = Dust.getFromName(args[1])) != null) {
                            this.methods.addItemToInventory(player, args.length >= 5 ? dust.getDust(percent, amount) : dust.getDust(amount));
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            placeholders.put("%Amount%", String.valueOf(amount));
                            placeholders.put("%Player%", player.getName());
                            switch (dust) {
                                case SUCCESS_DUST: {
                                    player.sendMessage(Messages.GET_SUCCESS_DUST.getMessage(placeholders));
                                    sender.sendMessage(Messages.GIVE_SUCCESS_DUST.getMessage(placeholders));
                                    break;
                                }
                                case DESTROY_DUST: {
                                    player.sendMessage(Messages.GET_DESTROY_DUST.getMessage(placeholders));
                                    sender.sendMessage(Messages.GIVE_DESTROY_DUST.getMessage(placeholders));
                                    break;
                                }
                                case MYSTERY_DUST: {
                                    player.sendMessage(Messages.GET_MYSTERY_DUST.getMessage(placeholders));
                                    sender.sendMessage(Messages.GIVE_MYSTERY_DUST.getMessage(placeholders));
                                }
                            }
                            return true;
                        }
                    }
                    sender.sendMessage((Component)ColorUtils.legacyTranslateColourCodes(ColorUtils.getPrefix() + "&c/ce Dust <Success/Destroy/Mystery> <Amount> [Player] [Percent]"));
                }
                return true;
            }
            case "scroll": {
                if (this.hasPermission(sender, "scroll")) {
                    if (args.length >= 2) {
                        Scrolls scroll;
                        int amount = 1;
                        String name2 = sender.getName();
                        if (args.length >= 3) {
                            if (!this.checkInt(sender, args[2])) {
                                return true;
                            }
                            amount = Integer.parseInt(args[2]);
                        }
                        if (args.length >= 4) {
                            name2 = args[3];
                            if (!this.methods.isPlayerOnline(name2, sender)) {
                                return true;
                            }
                        } else if (!isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        if ((scroll = Scrolls.getFromName(args[1])) != null) {
                            this.methods.addItemToInventory(this.methods.getPlayer(name2), scroll.getScroll(amount));
                            return true;
                        }
                    }
                    sender.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&c/ce Scroll <White/Black/Transmog> [Amount] [Player]"));
                }
                return true;
            }
            case "add": {
                if (this.hasPermission(sender, "add")) {
                    if (!isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        boolean isVanilla;
                        Player player = (Player)sender;
                        String level = "1";
                        if (args.length >= 3) {
                            if (!this.checkInt(sender, args[2])) {
                                return true;
                            }
                            level = args[2];
                        }
                        Enchantment vanillaEnchantment = this.methods.getEnchantment(args[1]);
                        CEnchantment ceEnchantment = this.crazyManager.getEnchantmentFromName(args[1]);
                        boolean bl = isVanilla = vanillaEnchantment != null;
                        if (vanillaEnchantment == null && ceEnchantment == null) {
                            sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                            return true;
                        }
                        if (this.methods.getItemInHand(player).getType() == Material.AIR) {
                            sender.sendMessage(Messages.DOESNT_HAVE_ITEM_IN_HAND.getMessage());
                            return true;
                        }
                        if (isVanilla) {
                            ItemStack item = this.methods.getItemInHand(player).clone();
                            item.addUnsafeEnchantment(vanillaEnchantment, Integer.parseInt(level));
                            this.methods.setItemInHand(player, item);
                        } else {
                            this.methods.setItemInHand(player, this.crazyManager.addEnchantment(this.methods.getItemInHand(player), ceEnchantment, Integer.parseInt(level)));
                        }
                        return true;
                    }
                    sender.sendMessage(ColorUtils.getPrefix("&c/ce add <Enchantment> [LvL]"));
                }
                return true;
            }
            case "remove": {
                if (this.hasPermission(sender, "remove")) {
                    if (!isPlayer) {
                        sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                        return true;
                    }
                    if (args.length >= 2) {
                        boolean isVanilla;
                        Player player = (Player)sender;
                        Enchantment vanillaEnchantment = this.methods.getEnchantment(args[1]);
                        CEnchantment ceEnchantment = this.crazyManager.getEnchantmentFromName(args[1]);
                        boolean bl = isVanilla = vanillaEnchantment != null;
                        if (vanillaEnchantment == null && ceEnchantment == null) {
                            sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                            return true;
                        }
                        if (this.methods.getItemInHand(player).getType() == Material.AIR) {
                            sender.sendMessage(Messages.DOESNT_HAVE_ITEM_IN_HAND.getMessage());
                            return true;
                        }
                        ItemStack item = this.methods.getItemInHand(player);
                        if (isVanilla) {
                            ItemStack clone = this.methods.getItemInHand(player).clone();
                            clone.removeEnchantment(vanillaEnchantment);
                            this.methods.setItemInHand(player, clone);
                            return true;
                        }
                        if (this.enchantmentBookSettings.getEnchantments(item).containsKey(ceEnchantment)) {
                            this.methods.setItemInHand(player, this.enchantmentBookSettings.removeEnchantment(item, ceEnchantment));
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            placeholders.put("%Enchantment%", ceEnchantment.getCustomName());
                            player.sendMessage(Messages.REMOVED_ENCHANTMENT.getMessage(placeholders).replaceAll("&", ""));
                            return true;
                        }
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("%Enchantment%", args[1]);
                        sender.sendMessage(Messages.DOESNT_HAVE_ENCHANTMENT.getMessage(placeholders));
                    }
                    sender.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&c/ce Remove <Enchantment>"));
                }
                return true;
            }
            case "book": {
                if (this.hasPermission(sender, "book")) {
                    if (args.length >= 2) {
                        Player player;
                        if (args.length == 2 && !isPlayer) {
                            sender.sendMessage(Messages.PLAYERS_ONLY.getMessage());
                            return true;
                        }
                        CEnchantment enchantment = this.crazyManager.getEnchantmentFromName(args[1]);
                        int level = 1;
                        int amount = 1;
                        if (args.length >= 3) {
                            if (NumberUtils.isInt(args[2])) {
                                level = Integer.parseInt(args[2]);
                            } else if (args[2].contains("-")) {
                                level = this.methods.getRandomNumber(args[2]);
                            } else {
                                sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", args[2]).replace("%arg%", args[2]));
                                return true;
                            }
                        }
                        if (args.length >= 4) {
                            if (!this.checkInt(sender, args[3])) {
                                return true;
                            }
                            amount = Integer.parseInt(args[3]);
                        }
                        if (args.length >= 5) {
                            if (!this.methods.isPlayerOnline(args[4], sender)) {
                                return true;
                            }
                            player = this.methods.getPlayer(args[4]);
                        } else {
                            assert (sender instanceof Player);
                            player = (Player)sender;
                        }
                        if (enchantment == null) {
                            sender.sendMessage(Messages.NOT_AN_ENCHANTMENT.getMessage());
                            return true;
                        }
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("%Player%", player.getName());
                        sender.sendMessage(Messages.SEND_ENCHANTMENT_BOOK.getMessage(placeholders));
                        this.methods.addItemToInventory(player, new CEBook(enchantment, level, amount).buildBook());
                        return true;
                    }
                    sender.sendMessage(ColorUtils.getPrefix() + ColorUtils.color("&c/ce Book <Enchantment> [Lvl] [Amount] [Player]"));
                }
                return true;
            }
        }
        sender.sendMessage(ColorUtils.getPrefix("&cDo /ce help for more info."));
        return false;
    }

    private void sendArmorStats(Player target, Player sender) {
        Arrays.stream(target.getEquipment().getArmorContents()).filter(Objects::nonNull).forEach(item -> {
            StringBuilder enchantmentsString = new StringBuilder();
            String main = Messages.MAIN_UPDATE_ENCHANTS.getMessageNoPrefix();
            main = main.replace("%item%", item.getType().toString());
            this.enchantmentBookSettings.getEnchantments((ItemStack)item).forEach((enchantment, level) -> enchantmentsString.append(Messages.BASE_UPDATE_ENCHANTS.getMessageNoPrefix((Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("%enchant%", enchantment.getName());
                    this.put("%level%", String.valueOf(level));
                }
            })));
            main = main.replace("%itemEnchants%", enchantmentsString.toString());
            sender.sendMessage(main);
        });
    }

    private boolean checkInt(CommandSender sender, String arg) {
        if (NumberUtils.isInt(arg)) {
            return true;
        }
        sender.sendMessage(Messages.NOT_A_NUMBER.getMessage().replace("%Arg%", arg).replace("%arg%", arg));
        return false;
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        return this.methods.hasPermission(sender, permission, true);
    }
}

