/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.utils;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.EnchantedArrow;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class BowUtils {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private final List<Block> webBlocks = new ArrayList<Block>();
    private final List<EnchantedArrow> enchantedArrows = new ArrayList<EnchantedArrow>();

    public void addArrow(Arrow arrow, ItemStack bow, Map<CEnchantment, Integer> enchantments) {
        if (arrow == null) {
            return;
        }
        EnchantedArrow enchantedArrow = new EnchantedArrow(arrow, bow, enchantments);
        this.enchantedArrows.add(enchantedArrow);
    }

    public void removeArrow(EnchantedArrow enchantedArrow) {
        if (!this.enchantedArrows.contains(enchantedArrow) || enchantedArrow == null) {
            return;
        }
        this.enchantedArrows.remove(enchantedArrow);
    }

    public boolean isBowEnchantActive(CEnchantments customEnchant, EnchantedArrow enchantedArrow) {
        return customEnchant.isActivated() && enchantedArrow.hasEnchantment(customEnchant) && customEnchant.chanceSuccessful(enchantedArrow.getLevel(customEnchant));
    }

    public boolean allowsCombat(Entity entity) {
        return this.starter.getPluginSupport().allowCombat(entity.getLocation());
    }

    public EnchantedArrow getEnchantedArrow(Arrow arrow) {
        return this.enchantedArrows.stream().filter(enchArrow -> enchArrow != null && enchArrow.arrow() != null && enchArrow.arrow().equals((Object)arrow)).findFirst().orElse(null);
    }

    public void spawnArrows(Entity entity, Entity projectile, ItemStack bow) {
        Arrow spawnedArrow = (Arrow)entity.getWorld().spawn(projectile.getLocation(), Arrow.class);
        EnchantedArrow enchantedMultiArrow = new EnchantedArrow(spawnedArrow, bow, this.enchantmentBookSettings.getEnchantments(bow));
        this.enchantedArrows.add(enchantedMultiArrow);
        spawnedArrow.setShooter((ProjectileSource)entity);
        Vector vector = new Vector(this.randomSpread(), 0.0f, this.randomSpread());
        spawnedArrow.setVelocity(projectile.getVelocity().add(vector));
        if (((Arrow)projectile).isCritical()) {
            spawnedArrow.setCritical(true);
        }
        if (projectile.getFireTicks() > 0) {
            spawnedArrow.setFireTicks(projectile.getFireTicks());
        }
        spawnedArrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        this.enchantedArrows.remove(enchantedMultiArrow);
    }

    private float randomSpread() {
        float spread = 0.2f;
        return -spread + (float)(Math.random() * (double)(spread * 2.0f));
    }

    public List<Block> getWebBlocks() {
        return this.webBlocks;
    }

    public void spawnWebs(Entity hitEntity, EnchantedArrow enchantedArrow, Arrow arrow) {
        if (enchantedArrow == null) {
            return;
        }
        if (!this.isBowEnchantActive(CEnchantments.STICKY_SHOT, enchantedArrow)) {
            return;
        }
        if (hitEntity == null) {
            Location entityLocation = arrow.getLocation();
            if (entityLocation.getBlock().getType() != Material.AIR) {
                return;
            }
            entityLocation.getBlock().setType(Material.COBWEB);
            this.webBlocks.add(entityLocation.getBlock());
            arrow.remove();
            this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, entityLocation, scheduledTask -> {
                entityLocation.getBlock().setType(Material.AIR);
                this.webBlocks.remove(entityLocation.getBlock());
            }, 100L);
        } else {
            arrow.remove();
            this.setWebBlocks(hitEntity);
        }
    }

    private void setWebBlocks(Entity hitEntity) {
        this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, hitEntity.getLocation(), () -> {
            for (Block block : this.getCube(hitEntity.getLocation())) {
                block.setType(Material.COBWEB);
                this.webBlocks.add(block);
                this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, block.getLocation(), scheduledTask -> {
                    if (block.getType() == Material.COBWEB) {
                        block.setType(Material.AIR);
                        this.webBlocks.remove(block);
                    }
                }, 100L);
            }
        });
    }

    private List<Block> getCube(Location start) {
        ArrayList<Block> newBlocks = new ArrayList<Block>();
        for (double x = start.getX() - 1.0; x <= start.getX() + 1.0; x += 1.0) {
            for (double z = start.getZ() - 1.0; z <= start.getZ() + 1.0; z += 1.0) {
                Location loc = new Location(start.getWorld(), x, start.getY(), z);
                if (loc.getBlock().getType() != Material.AIR) continue;
                newBlocks.add(loc.getBlock());
            }
        }
        return newBlocks;
    }
}

