/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.objects;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.blacksmith.BlackSmithManager;
import com.badbones69.crazyenchantments.paper.api.objects.BlackSmithCompare;
import com.badbones69.crazyenchantments.paper.api.objects.CEBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEItem;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class BlackSmithResult {
    private int cost = 0;
    private ItemStack resultItem;

    public BlackSmithResult(Player player, ItemStack mainItem, ItemStack subItem) {
        this.resultItem = mainItem.clone();
        CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
        CrazyManager crazyManager = plugin.getStarter().getCrazyManager();
        Starter starter = plugin.getStarter();
        EnchantmentBookSettings enchantmentBookSettings = starter.getEnchantmentBookSettings();
        CEBook mainBook = enchantmentBookSettings.getCEBook(mainItem);
        CEBook subBook = enchantmentBookSettings.getCEBook(subItem);
        if (mainBook != null && subBook != null) {
            if (mainBook.getEnchantment() == subBook.getEnchantment() && mainBook.getLevel() == subBook.getLevel() && mainBook.getLevel() + 1 <= mainBook.getEnchantment().getMaxLevel()) {
                this.resultItem = mainBook.setLevel(mainBook.getLevel() + 1).buildBook();
                this.cost += BlackSmithManager.getBookUpgrade();
            }
        } else if (mainItem.getType() == subItem.getType()) {
            int subLevel;
            int level;
            Object enchantment;
            CEItem mainCE = new CEItem(this.resultItem);
            CEItem subCE = new CEItem(subItem);
            BlackSmithCompare compare = new BlackSmithCompare(mainCE, subCE);
            for (Map.Entry<Enchantment, Integer> entry : mainCE.getVanillaEnchantments().entrySet()) {
                enchantment = entry.getKey();
                level = entry.getValue();
                subLevel = subCE.getVanillaEnchantmentLevel((Enchantment)enchantment);
                if (!enchantment.canEnchantItem(subItem) || !subCE.hasVanillaEnchantment((Enchantment)enchantment)) continue;
                if (level == subLevel && level < enchantment.getMaxLevel()) {
                    mainCE.setVanillaEnchantment((Enchantment)enchantment, level + 1);
                    this.cost += BlackSmithManager.getLevelUp();
                    continue;
                }
                if (level >= subLevel) continue;
                mainCE.setVanillaEnchantment((Enchantment)enchantment, subLevel);
                this.cost += BlackSmithManager.getLevelUp();
            }
            for (Map.Entry<Object, Integer> entry : mainCE.getCEnchantments().entrySet()) {
                enchantment = (CEnchantment)entry.getKey();
                level = entry.getValue();
                subLevel = subCE.getCEnchantmentLevel((CEnchantment)enchantment);
                if (!((CEnchantment)enchantment).canEnchantItem(subItem) || !subCE.hasCEnchantment((CEnchantment)enchantment)) continue;
                if (level == subLevel && level < ((CEnchantment)enchantment).getMaxLevel()) {
                    mainCE.setCEnchantment((CEnchantment)enchantment, level + 1);
                    this.cost += BlackSmithManager.getLevelUp();
                    continue;
                }
                if (level >= subLevel) continue;
                mainCE.setCEnchantment((CEnchantment)enchantment, subLevel);
                this.cost += BlackSmithManager.getLevelUp();
            }
            for (Map.Entry<Object, Integer> entry : compare.getNewVanillaEnchantments().entrySet()) {
                enchantment = (Enchantment)entry.getKey();
                if (!enchantment.canEnchantItem(subItem) || !crazyManager.canAddEnchantment(player, mainItem)) continue;
                mainCE.setVanillaEnchantment((Enchantment)enchantment, entry.getValue());
                this.cost += BlackSmithManager.getAddEnchantment();
            }
            for (Map.Entry<Object, Integer> entry : compare.getNewCEnchantments().entrySet()) {
                enchantment = (CEnchantment)entry.getKey();
                if (!((CEnchantment)enchantment).canEnchantItem(subItem) || !crazyManager.canAddEnchantment(player, mainItem) || !crazyManager.canAddEnchantment(player, subItem)) continue;
                mainCE.setCEnchantment((CEnchantment)enchantment, entry.getValue());
                this.cost += BlackSmithManager.getAddEnchantment();
            }
            mainCE.build();
        }
    }

    public int getCost() {
        return this.cost;
    }

    public ItemStack getResultItem() {
        return this.resultItem;
    }
}

