/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.enums;

import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scrolls
extends Enum<Scrolls> {
    public static final /* enum */ Scrolls BLACK_SCROLL = new Scrolls("Black-Scroll", "BlackScroll", Arrays.asList("b", "black", "blackscroll"));
    public static final /* enum */ Scrolls WHITE_SCROLL = new Scrolls("White-Scroll", "WhiteScroll", Arrays.asList("w", "white", "whitescroll"));
    public static final /* enum */ Scrolls TRANSMOG_SCROLL = new Scrolls("Transmog-Scroll", "TransmogScroll", Arrays.asList("t", "transmog", "transmogscroll"));
    private static final HashMap<Scrolls, ItemBuilder> itemBuilderScrolls;
    private final String name;
    private final String configName;
    private final List<String> knownNames;
    private static final NamespacedKey scroll;
    private static final NamespacedKey whiteScrollProtectionKey;
    private static final /* synthetic */ Scrolls[] $VALUES;

    public static Scrolls[] values() {
        return (Scrolls[])$VALUES.clone();
    }

    public static Scrolls valueOf(String name) {
        return Enum.valueOf(Scrolls.class, name);
    }

    private Scrolls(String name, String configName, List<String> knowNames) {
        this.name = name;
        this.knownNames = knowNames;
        this.configName = configName;
    }

    public static void loadScrolls() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        itemBuilderScrolls.clear();
        for (Scrolls scroll : Scrolls.values()) {
            String path = "Settings." + scroll.getConfigName() + ".";
            itemBuilderScrolls.put(scroll, new ItemBuilder().setName(config.getString(path + "Name", "Error getting name.")).setLore(config.getStringList(path + "Item-Lore")).setMaterial(config.getString(path + "Item", "BOOK")).setGlow(config.getBoolean(path + "Glowing", false)));
        }
    }

    public static Scrolls getFromName(String nameString) {
        for (Scrolls scroll : Scrolls.values()) {
            if (!scroll.getKnownNames().contains(nameString.toLowerCase())) continue;
            return scroll;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getKnownNames() {
        return this.knownNames;
    }

    public String getConfigName() {
        return this.configName;
    }

    public static Scrolls getFromPDC(ItemStack item) {
        PersistentDataContainer data = item.getItemMeta().getPersistentDataContainer();
        if (!item.hasItemMeta() || !data.has(scroll)) {
            return null;
        }
        return Scrolls.getFromName((String)data.get(scroll, PersistentDataType.STRING));
    }

    public ItemStack getScroll() {
        ItemStack item = itemBuilderScrolls.get((Object)this).build();
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(scroll, PersistentDataType.STRING, (Object)this.configName);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getScroll(int amount) {
        ItemStack item = itemBuilderScrolls.get((Object)this).setAmount(amount).build();
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(scroll, PersistentDataType.STRING, (Object)this.configName);
        item.setItemMeta(meta);
        return item;
    }

    public static String getWhiteScrollProtectionName() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        String protectNamed = ColorUtils.color(config.getString("Settings.WhiteScroll.ProtectedName"));
        return protectNamed;
    }

    public static boolean hasWhiteScrollProtection(@NotNull ItemStack item) {
        return item.hasItemMeta() && Scrolls.hasWhiteScrollProtection(item.getItemMeta());
    }

    public static boolean hasWhiteScrollProtection(@Nullable ItemMeta meta) {
        return meta != null && Scrolls.hasWhiteScrollProtection(meta.getPersistentDataContainer());
    }

    public static boolean hasWhiteScrollProtection(@Nullable PersistentDataContainer data) {
        return data != null && data.has(whiteScrollProtectionKey);
    }

    public static ItemStack addWhiteScrollProtection(@NotNull ItemStack item) {
        List lore;
        assert (item.hasItemMeta());
        ItemMeta meta = item.getItemMeta();
        List list = lore = item.lore() != null ? item.lore() : new ArrayList();
        assert (lore != null);
        lore.add(ColorUtils.legacyTranslateColourCodes(Scrolls.getWhiteScrollProtectionName()));
        meta.getPersistentDataContainer().set(whiteScrollProtectionKey, PersistentDataType.BOOLEAN, (Object)true);
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack removeWhiteScrollProtection(@NotNull ItemStack item) {
        if (!item.hasItemMeta()) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.getPersistentDataContainer().has(whiteScrollProtectionKey, PersistentDataType.BOOLEAN)) {
            meta.getPersistentDataContainer().remove(whiteScrollProtectionKey);
        }
        if (item.lore() == null) {
            item.setItemMeta(meta);
            return item;
        }
        List lore = item.lore();
        lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(Scrolls.getWhiteScrollProtectionName())));
        meta.lore(lore);
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private static /* synthetic */ Scrolls[] $values() {
        return new Scrolls[]{BLACK_SCROLL, WHITE_SCROLL, TRANSMOG_SCROLL};
    }

    static {
        $VALUES = Scrolls.$values();
        itemBuilderScrolls = new HashMap();
        scroll = DataKeys.scroll.getNamespacedKey();
        whiteScrollProtectionKey = DataKeys.white_scroll_protection.getNamespacedKey();
    }
}

