/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.builders.types;

import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.builders.InventoryBuilder;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.builders.types.MenuManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.gkitz.KitsManager;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.enchants.EnchantmentType;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class BaseMenu
extends InventoryBuilder {
    @NotNull
    private final Starter starter;
    @NotNull
    private final EnchantmentBookSettings bookSettings;

    public BaseMenu(Player player, int size, String title) {
        super(player, size, title);
        this.starter = this.plugin.getStarter();
        this.bookSettings = this.starter.getEnchantmentBookSettings();
    }

    @Override
    public InventoryBuilder build() {
        if (this.getEnchantmentType() != null) {
            List<CEnchantment> enchantments = this.getEnchantmentType().getEnchantments();
            ItemBuilder book = this.bookSettings.getNormalBook().setGlow(true);
            for (CEnchantment enchantment : enchantments) {
                if (!enchantment.isActivated()) continue;
                this.getInventory().addItem(new ItemStack[]{book.setName(enchantment.getInfoName()).setLore(enchantment.getInfoDescription()).build()});
            }
            this.getInventory().setItem(this.getSize() - 1, KitsManager.getBackRight());
        } else {
            MenuManager.getEnchantmentTypes().forEach(key -> this.getInventory().setItem(key.getSlot(), key.getDisplayItem()));
        }
        return this;
    }

    public static class InfoMenuListener
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void onInfoClick(InventoryClickEvent event) {
            InventoryHolder inventoryHolder = event.getInventory().getHolder();
            if (!(inventoryHolder instanceof BaseMenu)) {
                return;
            }
            BaseMenu holder = (BaseMenu)inventoryHolder;
            event.setCancelled(true);
            Player player = holder.getPlayer();
            ItemStack itemStack = event.getCurrentItem();
            if (itemStack == null) {
                return;
            }
            if (!itemStack.hasItemMeta()) {
                return;
            }
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta == null) {
                return;
            }
            if (!itemMeta.hasDisplayName()) {
                return;
            }
            if (itemStack.isSimilar(KitsManager.getBackLeft()) || itemStack.isSimilar(KitsManager.getBackRight())) {
                MenuManager.openInfoMenu(player);
                return;
            }
            for (EnchantmentType enchantmentType : MenuManager.getEnchantmentTypes()) {
                if (!itemStack.isSimilar(enchantmentType.getDisplayItem())) continue;
                MenuManager.openInfoMenu(player, enchantmentType);
                return;
            }
        }
    }
}

