/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MigrateManager {
    @NotNull
    private static final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);

    public static void convert() {
        double tinkerVersion = 1.1;
        File firstFile = new File(String.valueOf(plugin.getDataFolder()) + "/Tinker.yml");
        File secondFile = new File(String.valueOf(plugin.getDataFolder()) + "/Tinker-v1.yml");
        FileConfiguration TINKER = FileManager.Files.TINKER.getFile();
        if (TINKER.getDouble("Settings.Tinker-Version") >= tinkerVersion) {
            plugin.getLogger().info("Tinker.yml is up to date.");
            return;
        }
        plugin.getLogger().warning("Updating Tinker.yml version.");
        TINKER.set("Settings.Tinker-Version", (Object)tinkerVersion);
        FileManager.Files.TINKER.saveFile();
        if (firstFile.renameTo(secondFile)) {
            plugin.getLogger().warning("Renamed " + firstFile.getName() + " to Tinker-v1.yml");
            FileManager.Files.TINKER.saveFile();
        }
        YamlConfiguration secondConfiguration = YamlConfiguration.loadConfiguration((File)secondFile);
        for (String settings : secondConfiguration.getConfigurationSection("Settings").getKeys(false)) {
            TINKER.set("Settings." + settings, secondConfiguration.get("Settings." + settings));
        }
        for (String enchantment : secondConfiguration.getConfigurationSection("Tinker.Vanilla-Enchantments").getKeys(false)) {
            int amount = secondConfiguration.getInt("Tinker.Vanilla-Enchantments." + enchantment);
            TINKER.set("Tinker.Vanilla-Enchantments." + enchantment, (Object)(amount + ", 1"));
        }
        for (String enchantment : secondConfiguration.getConfigurationSection("Tinker.Crazy-Enchantments").getKeys(false)) {
            for (String itemBook : secondConfiguration.getConfigurationSection("Tinker.Crazy-Enchantments." + enchantment).getKeys(false)) {
                int value = secondConfiguration.getInt("Tinker.Crazy-Enchantments." + enchantment + "." + itemBook);
                TINKER.set("Tinker.Crazy-Enchantments." + enchantment + "." + itemBook, (Object)(value + ", 1"));
            }
        }
        FileManager.Files.TINKER.saveFile();
        plugin.getLogger().warning("Tinker.yml file has been updated.");
    }
}

