/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.MenuManager;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.objects.enchants.EnchantmentType;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.api.utils.NumberUtils;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import com.badbones69.crazyenchantments.paper.support.misc.OraxenSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Methods {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();
    @NotNull
    private final OraxenSupport oraxenSupport = this.starter.getOraxenSupport();

    public EnchantmentType getFromName(String name) {
        for (EnchantmentType enchantmentType : MenuManager.getEnchantmentTypes()) {
            if (!enchantmentType.getName().equalsIgnoreCase(name)) continue;
            return enchantmentType;
        }
        return null;
    }

    public int getRandomNumber(String range) {
        int number = 1;
        String[] split = range.split("-");
        if (NumberUtils.isInt(split[0]) && NumberUtils.isInt(split[1])) {
            int max = Integer.parseInt(split[1]) + 1;
            int min = Integer.parseInt(split[0]);
            number = this.getRandomNumber(min, max);
        }
        return number;
    }

    public int getRandomNumber(int min, int max) {
        Random random = new Random();
        return min + random.nextInt(max - min);
    }

    public boolean hasPermission(CommandSender sender, String perm, boolean toggle) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.hasPermission(player, perm, toggle);
        }
        return true;
    }

    public boolean hasPermission(Player player, String perm, boolean toggle) {
        if (player.hasPermission("crazyenchantments." + perm) || player.hasPermission("crazyenchantments.admin")) {
            return true;
        }
        if (toggle) {
            player.sendMessage(Messages.NO_PERMISSION.getMessage());
        }
        return false;
    }

    @NotNull
    public ItemStack getItemInHand(@NotNull Player player) {
        return player.getInventory().getItemInMainHand();
    }

    public void setItemInHand(@NotNull Player player, @Nullable ItemStack item) {
        player.getInventory().setItemInMainHand(item);
    }

    @Nullable
    public Player getPlayer(String name) {
        return this.plugin.getServer().getPlayer(name);
    }

    public boolean isPlayerOnline(String playerName, CommandSender sender) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(playerName)) continue;
            return true;
        }
        sender.sendMessage(Messages.NOT_ONLINE.getMessage());
        return false;
    }

    public void removeItem(@NotNull ItemStack item, @NotNull Player player) {
        this.removeItem(item, player, 1);
    }

    public void removeItem(@NotNull ItemStack item, @NotNull Player player, int amount) {
        try {
            ItemStack offHand;
            boolean found = false;
            if (player.getInventory().contains(item)) {
                if (item.getAmount() <= amount) {
                    player.getInventory().removeItem(new ItemStack[]{item});
                    found = true;
                } else {
                    found = true;
                    item.setAmount(item.getAmount() - amount);
                }
            }
            if (!found && (offHand = player.getEquipment().getItemInOffHand()).isSimilar(item)) {
                if (amount - offHand.getAmount() >= 0) {
                    player.getEquipment().setItemInOffHand(new ItemStack(Material.AIR, 1));
                } else {
                    item.setAmount(offHand.getAmount() - amount);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public ItemStack removeItem(@NotNull ItemStack item) {
        return this.removeItem(item, 1);
    }

    @Nullable
    public ItemStack removeItem(@NotNull ItemStack item, int amount) {
        ItemStack itemStack = item.clone();
        if (item.getAmount() <= amount) {
            itemStack = null;
        } else {
            itemStack.setAmount(item.getAmount() - amount);
        }
        return itemStack;
    }

    @NotNull
    public ItemStack addLore(@NotNull ItemStack item, String loreString) {
        ArrayList<TextComponent> lore = item.lore();
        if (lore == null) {
            lore = new ArrayList<TextComponent>();
        }
        lore.add(ColorUtils.legacyTranslateColourCodes(loreString));
        item.lore(lore);
        return item;
    }

    public boolean hasArgument(@NotNull String arg, @NotNull List<String> message) {
        for (String line : message) {
            if (!(line = ColorUtils.color(line).toLowerCase()).contains(arg.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean randomPicker(int min, int max) {
        if (max <= min || max <= 0) {
            return true;
        }
        Random random = new Random();
        int chance = 1 + random.nextInt(max);
        return chance <= min;
    }

    public Integer percentPick(int max, int min) {
        if (max == min) {
            return max;
        }
        Random random = new Random();
        return min + random.nextInt(max - min);
    }

    public boolean isInventoryFull(@NotNull Player player) {
        if (player.getInventory().firstEmpty() != -1) {
            return false;
        }
        player.sendMessage(Messages.INVENTORY_FULL.getMessage());
        return true;
    }

    public void addItemToInventory(@NotNull Player player, @NotNull ItemStack item) {
        player.getInventory().addItem(new ItemStack[]{item}).values().forEach(x -> player.getWorld().dropItem(player.getLocation(), x));
    }

    public void addItemToInventory(@NotNull Player player, @NotNull List<Item> itemList) {
        itemList.forEach(x -> this.addItemToInventory(player, x.getItemStack()));
    }

    @NotNull
    public List<LivingEntity> getNearbyLivingEntities(double radius, @NotNull Entity entity) {
        List out = entity.getNearbyEntities(radius, radius, radius);
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (Entity en : out) {
            if (!(en instanceof LivingEntity)) continue;
            entities.add((LivingEntity)en);
        }
        return entities;
    }

    @NotNull
    public List<Entity> getNearbyEntities(double radius, @NotNull Entity entity) {
        return entity.getNearbyEntities(radius, radius, radius);
    }

    public void fireWork(@NotNull Location loc, @NotNull List<Color> colors) {
        this.fireWork(loc, new ArrayList<Color>(colors));
    }

    public void fireWork(@NotNull Location loc, @NotNull ArrayList<Color> colors) {
        Firework firework = (Firework)loc.getWorld().spawn(loc, Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.addEffects(new FireworkEffect[]{FireworkEffect.builder().with(FireworkEffect.Type.BALL_LARGE).withColor(colors).trail(false).flicker(false).build()});
        fireworkMeta.setPower(0);
        firework.setFireworkMeta(fireworkMeta);
        this.plugin.getFireworkDamageListener().addFirework((Entity)firework);
        this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, loc, task -> firework.detonate(), 2L);
    }

    public Enchantment getEnchantment(@NotNull String enchantmentName) {
        try {
            enchantmentName = enchantmentName.replaceAll("-|_| ", "");
            for (Enchantment enchantment : Enchantment.values()) {
                if (!enchantment.getKey().getKey().replaceAll("-|_| ", "").equalsIgnoreCase(enchantmentName)) continue;
                return enchantment;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getMaxDurability(@NotNull ItemStack item) {
        if (!PluginSupport.SupportedPlugins.ORAXEN.isPluginLoaded()) {
            return item.getType().getMaxDurability();
        }
        return this.oraxenSupport.getMaxDurability(item);
    }

    public int getDurability(@NotNull ItemStack item) {
        if (!PluginSupport.SupportedPlugins.ORAXEN.isPluginLoaded()) {
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof Damageable) {
                return ((Damageable)item.getItemMeta()).getDamage();
            }
            return 0;
        }
        return this.oraxenSupport.getDamage(item);
    }

    public void setDurability(@NotNull ItemStack item, int newDamage) {
        newDamage = Math.max(newDamage, 0);
        if (!PluginSupport.SupportedPlugins.ORAXEN.isPluginLoaded()) {
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                damageable.setDamage(newDamage);
                item.setItemMeta((ItemMeta)damageable);
            }
            return;
        }
        this.oraxenSupport.setDamage(item, newDamage);
    }

    public void removeDurability(@NotNull ItemStack item, @NotNull Player player) {
        if (this.getMaxDurability(item) == 0) {
            return;
        }
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.isUnbreakable()) {
                return;
            }
            if (meta.hasEnchants() && meta.hasEnchant(Enchantment.UNBREAKING)) {
                if (this.randomPicker(1, 1 + item.getEnchantmentLevel(Enchantment.UNBREAKING))) {
                    if (this.getDurability(item) > this.getMaxDurability(item)) {
                        player.getInventory().remove(item);
                    } else {
                        this.setDurability(item, this.getDurability(item) + 1);
                    }
                }
                return;
            }
        }
        if (this.getDurability(item) > this.getMaxDurability(item)) {
            player.getInventory().remove(item);
        } else {
            this.setDurability(item, this.getDurability(item) + 1);
        }
    }

    public void explode(@NotNull Entity player) {
        this.spawnExplodeParticles(player.getWorld(), player.getLocation());
        for (Entity entity : this.getNearbyEntities(3.0, player)) {
            LivingEntity en;
            if (!this.pluginSupport.allowCombat(entity.getLocation())) continue;
            if (entity.getType() == EntityType.ITEM) {
                entity.remove();
                continue;
            }
            if (!(entity instanceof LivingEntity) || this.pluginSupport.isFriendly(player, (Entity)(en = (LivingEntity)entity)) || player.getName().equalsIgnoreCase(entity.getName())) continue;
            en.damage(5.0);
            en.setVelocity(en.getLocation().toVector().subtract(player.getLocation().toVector()).normalize().multiply(1).setY(0.5));
        }
    }

    private void spawnExplodeParticles(@NotNull World world, @NotNull Location location) {
        world.spawnParticle(Particle.FLAME, location, 200);
        world.spawnParticle(Particle.CLOUD, location, 30, (double)0.4f, 0.5, (double)0.4f);
        world.spawnParticle(Particle.EXPLOSION, location, 2);
        world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
    }

    public void explode(@NotNull Entity shooter, @NotNull Entity arrow) {
        this.spawnExplodeParticles(shooter.getWorld(), arrow.getLocation());
        for (Entity value : this.getNearbyEntities(3.0, arrow)) {
            LivingEntity livingEntity;
            if (!this.pluginSupport.allowCombat(value.getLocation())) continue;
            if (value.getType() == EntityType.ITEM) {
                value.remove();
                continue;
            }
            if (!(value instanceof LivingEntity) || this.pluginSupport.isFriendly(shooter, (Entity)(livingEntity = (LivingEntity)value)) || shooter.getName().equalsIgnoreCase(value.getName())) continue;
            EntityDamageEvent event = new EntityDamageEvent((Entity)livingEntity, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, DamageSource.builder((DamageType)DamageType.EXPLOSION).withCausingEntity(shooter).withDirectEntity(arrow).build(), 5.0);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            livingEntity.damage(5.0);
            livingEntity.setVelocity(livingEntity.getLocation().toVector().subtract(arrow.getLocation().toVector()).normalize().multiply(1).setY(0.5));
        }
    }

    @NotNull
    public HashSet<org.bukkit.block.Block> getEnchantBlocks(@NotNull Location loc, @NotNull Location loc2) {
        HashSet<org.bukkit.block.Block> blockList = new HashSet<org.bukkit.block.Block>();
        int topBlockX = Math.max(loc.getBlockX(), loc2.getBlockX());
        int bottomBlockX = Math.min(loc.getBlockX(), loc2.getBlockX());
        int topBlockY = Math.max(loc.getBlockY(), loc2.getBlockY());
        int bottomBlockY = Math.min(loc.getBlockY(), loc2.getBlockY());
        int topBlockZ = Math.max(loc.getBlockZ(), loc2.getBlockZ());
        int bottomBlockZ = Math.min(loc.getBlockZ(), loc2.getBlockZ());
        for (int x = bottomBlockX; x <= topBlockX; ++x) {
            for (int z = bottomBlockZ; z <= topBlockZ; ++z) {
                for (int y = bottomBlockY; y <= topBlockY; ++y) {
                    if (loc.getWorld() == null) continue;
                    blockList.add(loc.getWorld().getBlockAt(x, y, z));
                }
            }
        }
        return blockList;
    }

    public void entityEvent(@NotNull Player damager, @NotNull LivingEntity entity, @NotNull EntityDamageEvent damageByEntityEvent) {
        EventUtils.addIgnoredEvent((Event)damageByEntityEvent);
        EventUtils.addIgnoredUUID(damager.getUniqueId());
        this.plugin.getServer().getPluginManager().callEvent((Event)damageByEntityEvent);
        if (!damageByEntityEvent.isCancelled() && this.pluginSupport.allowCombat(entity.getLocation()) && !this.pluginSupport.isFriendly((Entity)damager, (Entity)entity)) {
            entity.damage(5.0);
        }
        EventUtils.removeIgnoredEvent((Event)damageByEntityEvent);
        EventUtils.removeIgnoredUUID(damager.getUniqueId());
    }

    public Entity lightning(@NotNull LivingEntity entity) {
        Location loc = entity.getLocation();
        LightningStrike lightning = null;
        if (loc.getWorld() != null) {
            lightning = loc.getWorld().strikeLightning(loc);
        }
        int lightningSoundRange = FileManager.Files.CONFIG.getFile().getInt("Settings.EnchantmentOptions.Lightning-Sound-Range", 160);
        try {
            loc.getWorld().playSound(loc, Sound.ENTITY_LIGHTNING_BOLT_IMPACT, (float)lightningSoundRange / 16.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lightning;
    }

    public void switchCurrency(@NotNull Player player, @NotNull Currency option, @NotNull String one, @NotNull String two, @NotNull String cost) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put(one, cost);
        placeholders.put(two, cost);
        switch (option) {
            case VAULT: {
                player.sendMessage(Messages.NEED_MORE_MONEY.getMessage(placeholders));
                break;
            }
            case XP_LEVEL: {
                player.sendMessage(Messages.NEED_MORE_XP_LEVELS.getMessage(placeholders));
                break;
            }
            case XP_TOTAL: {
                player.sendMessage(Messages.NEED_MORE_TOTAL_XP.getMessage(placeholders));
            }
        }
    }

    public boolean isEventCancelled(@NotNull Event event) {
        return !event.callEvent();
    }

    public boolean inCreativeMode(@NotNull Player player) {
        if (player.getGameMode() != GameMode.CREATIVE) {
            return false;
        }
        player.sendMessage(Messages.PLAYER_IS_IN_CREATIVE_MODE.getMessage());
        return true;
    }

    public void playItemBreak(@NotNull Player player, @NotNull ItemStack item) {
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.ITEM, player.getEyeLocation(), 10, 0.3, 0.5, 0.3, 0.0, (Object)item);
    }

    public boolean playerBreakBlock(@NotNull Player player, @NotNull org.bukkit.block.Block block, @NotNull ItemStack tool, boolean hasDrops) {
        Collection dropItems;
        BlockBreakEvent blockBreak = new BlockBreakEvent(block, player);
        Collection collection = dropItems = !tool.isEmpty() ? block.getDrops(tool, (Entity)player) : block.getDrops();
        if (dropItems.isEmpty()) {
            blockBreak.setDropItems(false);
        }
        blockBreak.setExpToDrop(this.getXPThroughNMS(block, tool));
        EventUtils.addIgnoredEvent((Event)blockBreak);
        this.plugin.getServer().getPluginManager().callEvent((Event)blockBreak);
        EventUtils.removeIgnoredEvent((Event)blockBreak);
        if (blockBreak.isCancelled()) {
            return true;
        }
        if (blockBreak.isDropItems() && hasDrops) {
            this.blockDropItems(player, block, dropItems);
        }
        this.dropXP(block, blockBreak.getExpToDrop());
        block.setType(Material.AIR);
        return false;
    }

    private void dropXP(@NotNull org.bukkit.block.Block block, int expToDrop) {
        if (expToDrop < 1) {
            return;
        }
        ExperienceOrb exp = (ExperienceOrb)block.getWorld().spawn(block.getLocation(), ExperienceOrb.class);
        exp.setExperience(expToDrop);
    }

    private void blockDropItems(@NotNull Player player, @NotNull org.bukkit.block.Block block, @NotNull Collection<ItemStack> items) {
        ArrayList dropItems = new ArrayList();
        items.forEach(item -> dropItems.add(block.getWorld().dropItemNaturally(block.getLocation(), item)));
        BlockDropItemEvent event = new BlockDropItemEvent(block, block.getState(), player, dropItems);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            dropItems.forEach(Entity::remove);
        }
    }

    private int getXPThroughNMS(@NotNull org.bukkit.block.Block block, @NotNull ItemStack item) {
        CraftBlock cb = (CraftBlock)block;
        BlockState iWorldblockdata = cb.getNMS();
        Block worldBlock = iWorldblockdata.getBlock();
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        return worldBlock.getExpDrop(iWorldblockdata, cb.getHandle().getMinecraftWorld(), cb.getPosition(), nmsItem, true);
    }
}

