/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.suggestion;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import libs.dev.triumphteam.cmd.core.suggestion.Suggestion;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleSuggestion<S>
implements Suggestion<S> {
    private final SuggestionResolver<S> resolver;
    private final SuggestionMethod method;

    public SimpleSuggestion(@NotNull SuggestionResolver<S> resolver, @NotNull SuggestionMethod method) {
        this.resolver = resolver;
        this.method = method;
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull S sender, @NotNull String current, @NotNull List<String> arguments) {
        Stream<Object> stream = this.resolver.resolve(sender, arguments).stream();
        switch (this.method) {
            case STARTS_WITH: {
                stream = stream.filter(it -> it.toLowerCase().startsWith(current.toLowerCase()));
                break;
            }
            case CONTAINS: {
                stream = stream.filter(it -> it.toLowerCase().contains(current.toLowerCase()));
                break;
            }
        }
        return stream.collect(Collectors.toList());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSuggestion that = (SimpleSuggestion)o;
        return this.resolver.equals(that.resolver);
    }

    public int hashCode() {
        return Objects.hash(this.resolver);
    }

    @NotNull
    public String toString() {
        return "SimpleSuggestion{resolver=" + this.resolver + '}';
    }
}

