/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.requirement;

import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.extention.registry.MessageRegistry;
import libs.dev.triumphteam.cmd.core.extention.sender.SenderMapper;
import libs.dev.triumphteam.cmd.core.message.MessageKey;
import libs.dev.triumphteam.cmd.core.message.context.BasicMessageContext;
import libs.dev.triumphteam.cmd.core.message.context.MessageContext;
import libs.dev.triumphteam.cmd.core.requirement.Requirement;
import libs.dev.triumphteam.cmd.core.requirement.RequirementResolver;
import libs.dev.triumphteam.cmd.core.requirement.SimpleRequirementContext;
import org.jetbrains.annotations.NotNull;

public final class InternalRequirement<D, S>
implements Requirement<D, S> {
    private final RequirementResolver<D, S> resolver;
    private final MessageKey<MessageContext> messageKey;
    private final boolean invert;

    public InternalRequirement(@NotNull RequirementResolver<D, S> resolver, @NotNull MessageKey<MessageContext> messageKey, boolean invert) {
        this.resolver = resolver;
        this.messageKey = messageKey;
        this.invert = invert;
    }

    @Override
    public boolean test(@NotNull S sender, @NotNull CommandMeta meta, @NotNull SenderMapper<D, S> senderMapper) {
        return this.resolver.resolve(sender, new SimpleRequirementContext<D, S>(meta, senderMapper)) != this.invert;
    }

    @Override
    public void onDeny(@NotNull S sender, @NotNull MessageRegistry<S> messageRegistry, @NotNull CommandMeta meta) {
        messageRegistry.sendMessage(this.messageKey, sender, new BasicMessageContext(meta));
    }

    @NotNull
    public String toString() {
        return "InternalRequirement{resolver=" + this.resolver + '}';
    }
}

