/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.processor;

import com.google.common.base.CaseFormat;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import libs.dev.triumphteam.cmd.core.AnnotatedCommand;
import libs.dev.triumphteam.cmd.core.annotations.Description;
import libs.dev.triumphteam.cmd.core.annotations.Syntax;
import libs.dev.triumphteam.cmd.core.argument.InternalArgument;
import libs.dev.triumphteam.cmd.core.argument.StringInternalArgument;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import libs.dev.triumphteam.cmd.core.command.Command;
import libs.dev.triumphteam.cmd.core.command.ParentSubCommand;
import libs.dev.triumphteam.cmd.core.command.SubCommand;
import libs.dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import libs.dev.triumphteam.cmd.core.extention.CommandOptions;
import libs.dev.triumphteam.cmd.core.extention.annotation.ProcessorTarget;
import libs.dev.triumphteam.cmd.core.extention.command.Settings;
import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.extention.meta.MetaKey;
import libs.dev.triumphteam.cmd.core.extention.registry.RegistryContainer;
import libs.dev.triumphteam.cmd.core.processor.CommandProcessor;
import libs.dev.triumphteam.cmd.core.processor.ParentCommandProcessor;
import libs.dev.triumphteam.cmd.core.processor.SubCommandProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootCommandProcessor<D, S>
implements CommandProcessor<D, S> {
    private final Object invocationInstance;
    private final String name;
    private final Syntax syntax;
    private final List<String> aliases;
    private final String description;
    private final CommandOptions<D, S> commandOptions;
    private final RegistryContainer<D, S> registryContainer;

    public RootCommandProcessor(@NotNull Object invocationInstance, @NotNull RegistryContainer<D, S> registryContainer, @NotNull CommandOptions<D, S> commandOptions) {
        this.invocationInstance = invocationInstance;
        this.name = this.nameOf();
        this.aliases = this.aliasesOf();
        this.description = this.descriptionOf();
        this.registryContainer = registryContainer;
        this.commandOptions = commandOptions;
        this.syntax = invocationInstance.getClass().getAnnotation(Syntax.class);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public CommandOptions<D, S> getCommandOptions() {
        return this.commandOptions;
    }

    @Override
    @NotNull
    public RegistryContainer<D, S> getRegistryContainer() {
        return this.registryContainer;
    }

    @Override
    @Nullable
    public Syntax getSyntaxAnnotation() {
        return this.syntax;
    }

    @Override
    @NotNull
    public AnnotatedElement getAnnotatedElement() {
        return this.invocationInstance.getClass();
    }

    @Override
    @NotNull
    public CommandMeta createMeta(@NotNull @NotNull @NotNull Settings.Builder<D, S> settingsBuilder) {
        CommandMeta.Builder meta = new CommandMeta.Builder(null);
        meta.add(MetaKey.NAME, this.getName());
        meta.add(MetaKey.DESCRIPTION, this.getDescription());
        Class<?> klass = this.invocationInstance.getClass();
        this.processAnnotations(this.commandOptions.getCommandExtensions(), klass, ProcessorTarget.ROOT_COMMAND, meta);
        this.processCommandMeta(this.commandOptions.getCommandExtensions(), klass, ProcessorTarget.PARENT_COMMAND, meta, settingsBuilder);
        return meta.build();
    }

    @NotNull
    public List<Command<D, S>> commands(@NotNull Command<D, S> parentCommand) {
        Class<?> klass = this.invocationInstance.getClass();
        ArrayList<Command<D, S>> subCommands = new ArrayList<Command<D, S>>();
        subCommands.addAll(this.methodCommands(parentCommand, klass.getDeclaredMethods()));
        subCommands.addAll(this.classCommands(parentCommand, klass.getDeclaredClasses()));
        return subCommands;
    }

    @NotNull
    private List<Command<D, S>> methodCommands(@NotNull Command<D, S> parentCommand, @NotNull Method[] methods) {
        ArrayList<Command<D, S>> commands = new ArrayList<Command<D, S>>();
        for (Method method : methods) {
            SubCommandProcessor<D, S> processor;
            if (!Modifier.isPublic(method.getModifiers()) || (processor = new SubCommandProcessor<D, S>(this.invocationInstance, method, this.registryContainer, this.commandOptions, parentCommand.getMeta())).getName() == null) continue;
            commands.add(new SubCommand<D, S>(this.invocationInstance, method, processor, parentCommand));
        }
        return commands;
    }

    @NotNull
    private List<Command<D, S>> classCommands(@NotNull Command<D, S> parentCommand, @NotNull Class<?>[] classes) {
        ArrayList<Command<D, S>> commands = new ArrayList<Command<D, S>>();
        for (Class<?> klass : classes) {
            InternalArgument argument;
            boolean hasArgument;
            ParentCommandProcessor processor;
            if (!Modifier.isPublic(klass.getModifiers()) || (processor = new ParentCommandProcessor(this.invocationInstance, klass, this.registryContainer, this.commandOptions, parentCommand.getMeta())).getName() == null) continue;
            Constructor<?>[] constructors = klass.getConstructors();
            if (constructors.length != 1) {
                throw new CommandRegistrationException("Inner command class can only have a single constructor, " + constructors.length + " found", klass);
            }
            Constructor<?> constructor = constructors[0];
            Parameter[] parameters = constructor.getParameters();
            boolean isStatic = Modifier.isStatic(klass.getModifiers());
            int arguments = isStatic ? parameters.length : parameters.length - 1;
            boolean bl = hasArgument = arguments != 0;
            if (arguments > 1) {
                throw new CommandRegistrationException("Inner command class can only have a maximum of 1 argument, " + arguments + " found", klass);
            }
            if (!hasArgument) {
                argument = null;
            } else {
                if (!"th-default".equals(processor.getName())) {
                    throw new CommandRegistrationException("Inner command class with argument must not have a name", klass);
                }
                Parameter parameter = isStatic ? parameters[0] : parameters[1];
                CommandMeta.Builder meta = new CommandMeta.Builder(null);
                this.processAnnotations(this.getCommandOptions().getCommandExtensions(), parameter, ProcessorTarget.ARGUMENT, meta);
                argument = processor.argumentFromParameter(meta.build(), parameter, Collections.emptyList(), Collections.emptyMap(), ArgumentGroup.flags(Collections.emptyList()), ArgumentGroup.named(Collections.emptyList()), 0);
                if (!(argument instanceof StringInternalArgument)) {
                    throw new CommandRegistrationException("Inner command class with argument must not be limitless, only single string argument is allowed", klass);
                }
            }
            ParentSubCommand<D, S> parent = new ParentSubCommand<D, S>(this.invocationInstance, constructor, isStatic, (StringInternalArgument)argument, processor, parentCommand);
            parent.addCommands(this.invocationInstance, this.methodCommands(parent, klass.getDeclaredMethods()));
            parent.addCommands(this.invocationInstance, this.classCommands(parentCommand, klass.getDeclaredClasses()));
            commands.add(parent);
        }
        return commands;
    }

    @NotNull
    private String nameOf() {
        Class<?> commandClass = this.invocationInstance.getClass();
        libs.dev.triumphteam.cmd.core.annotations.Command commandAnnotation = commandClass.getAnnotation(libs.dev.triumphteam.cmd.core.annotations.Command.class);
        String name = null;
        if (commandAnnotation != null) {
            name = commandAnnotation.value();
        } else if (AnnotatedCommand.class.isAssignableFrom(commandClass)) {
            name = ((AnnotatedCommand)this.invocationInstance).getCommand();
        }
        if (name == null) {
            throw new CommandRegistrationException("No \"@" + Command.class.getSimpleName() + "\" annotation found or class doesn't extend \"" + AnnotatedCommand.class.getSimpleName() + "\"", this.invocationInstance.getClass());
        }
        if (name.isEmpty() || name.equals("th-default")) {
            throw new CommandRegistrationException("Command name must not be empty", this.invocationInstance.getClass());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name);
    }

    @NotNull
    private List<String> aliasesOf() {
        Class<?> commandClass = this.invocationInstance.getClass();
        libs.dev.triumphteam.cmd.core.annotations.Command commandAnnotation = commandClass.getAnnotation(libs.dev.triumphteam.cmd.core.annotations.Command.class);
        List<String> aliases = null;
        if (commandAnnotation != null) {
            aliases = Arrays.asList(commandAnnotation.alias());
        } else if (AnnotatedCommand.class.isAssignableFrom(commandClass)) {
            aliases = ((AnnotatedCommand)this.invocationInstance).getAlias();
        }
        return aliases == null ? Collections.emptyList() : aliases.stream().map(name -> CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name)).collect(Collectors.toList());
    }

    @NotNull
    private String descriptionOf() {
        Class<?> commandClass = this.invocationInstance.getClass();
        Description descriptionAnnotation = commandClass.getAnnotation(Description.class);
        String description = "";
        if (descriptionAnnotation != null) {
            description = descriptionAnnotation.value();
        } else if (AnnotatedCommand.class.isAssignableFrom(commandClass)) {
            description = ((AnnotatedCommand)this.invocationInstance).getDescription();
        }
        return description;
    }
}

