/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import libs.dev.triumphteam.cmd.core.annotations.Requirement;
import libs.dev.triumphteam.cmd.core.annotations.Requirements;
import libs.dev.triumphteam.cmd.core.annotations.Syntax;
import libs.dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import libs.dev.triumphteam.cmd.core.extention.CommandExtensions;
import libs.dev.triumphteam.cmd.core.extention.CommandOptions;
import libs.dev.triumphteam.cmd.core.extention.annotation.AnnotationProcessor;
import libs.dev.triumphteam.cmd.core.extention.annotation.ProcessorTarget;
import libs.dev.triumphteam.cmd.core.extention.command.Settings;
import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.extention.registry.RegistryContainer;
import libs.dev.triumphteam.cmd.core.extention.registry.RequirementRegistry;
import libs.dev.triumphteam.cmd.core.message.MessageKey;
import libs.dev.triumphteam.cmd.core.message.context.MessageContext;
import libs.dev.triumphteam.cmd.core.requirement.InternalRequirement;
import libs.dev.triumphteam.cmd.core.requirement.RequirementKey;
import libs.dev.triumphteam.cmd.core.requirement.RequirementResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommandProcessor<D, S> {
    @NotNull
    public CommandMeta createMeta(@NotNull Settings.Builder<D, S> var1);

    @NotNull
    public CommandOptions<D, S> getCommandOptions();

    @NotNull
    public RegistryContainer<D, S> getRegistryContainer();

    @NotNull
    public AnnotatedElement getAnnotatedElement();

    @Nullable
    public Syntax getSyntaxAnnotation();

    default public void processAnnotations(@NotNull CommandExtensions<?, ?> extensions, @NotNull AnnotatedElement element, @NotNull ProcessorTarget target, @NotNull CommandMeta.Builder meta) {
        Map<Class<Annotation>, AnnotationProcessor<Annotation>> processors = extensions.getAnnotationProcessors();
        for (Annotation annotation : element.getAnnotations()) {
            AnnotationProcessor<Annotation> annotationProcessor = processors.get(annotation.annotationType());
            if (annotationProcessor == null) continue;
            annotationProcessor.process(annotation, target, element, meta);
        }
    }

    default public void captureRequirements(@NotNull Settings.Builder<D, S> settingsBuilder) {
        RequirementRegistry<D, S> requirementRegistry = this.getRegistryContainer().getRequirementRegistry();
        for (Requirement requirementAnnotation : this.getRequirementsFromAnnotations()) {
            RequirementKey requirementKey = RequirementKey.of(requirementAnnotation.value());
            String messageKeyValue = requirementAnnotation.messageKey();
            MessageKey<MessageContext> messageKey = MessageKey.of(messageKeyValue, MessageContext.class);
            RequirementResolver<D, S> resolver = requirementRegistry.getRequirement(requirementKey);
            if (resolver == null) {
                throw new CommandRegistrationException("Could not find Requirement Key \"" + requirementKey.getKey() + "\"");
            }
            settingsBuilder.addRequirement(new InternalRequirement<D, S>(resolver, messageKey, requirementAnnotation.invert()));
        }
    }

    default public void processCommandMeta(@NotNull CommandExtensions<D, S> extensions, @NotNull AnnotatedElement element, @NotNull ProcessorTarget target, @NotNull CommandMeta.Builder meta, @NotNull Settings.Builder<D, S> settingsBuilder) {
        extensions.getProcessors().forEach(it -> it.process(element, target, meta, settingsBuilder));
    }

    @NotNull
    default public @NotNull List<@NotNull Requirement> getRequirementsFromAnnotations() {
        AnnotatedElement element = this.getAnnotatedElement();
        Requirements requirements = element.getAnnotation(Requirements.class);
        if (requirements != null) {
            return Arrays.asList(requirements.value());
        }
        Requirement requirement = element.getAnnotation(Requirement.class);
        if (requirement == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(requirement);
    }
}

