/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.extention.command;

import java.util.List;
import libs.dev.triumphteam.cmd.core.extention.command.Settings;
import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.extention.registry.MessageRegistry;
import libs.dev.triumphteam.cmd.core.extention.sender.SenderMapper;
import libs.dev.triumphteam.cmd.core.requirement.Requirement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableSettings<D, S>
implements Settings<D, S> {
    private final List<Requirement<D, S>> requirements;

    public ImmutableSettings(@NotNull List<Requirement<D, S>> requirements) {
        this.requirements = requirements;
    }

    @Override
    public boolean testRequirements(@NotNull MessageRegistry<S> messageRegistry, @NotNull S sender, @NotNull CommandMeta meta, @NotNull SenderMapper<D, S> senderMapper) {
        Requirement<D, S> requirement = this.getFailedRequirement(sender, meta, senderMapper);
        if (requirement == null) {
            return true;
        }
        requirement.onDeny(sender, messageRegistry, meta);
        return false;
    }

    @Override
    public boolean testRequirements(@NotNull S sender, @NotNull CommandMeta meta, @NotNull SenderMapper<D, S> senderMapper) {
        return this.getFailedRequirement(sender, meta, senderMapper) == null;
    }

    @Nullable
    private Requirement<D, S> getFailedRequirement(@NotNull S sender, @NotNull CommandMeta meta, @NotNull SenderMapper<D, S> senderMapper) {
        for (Requirement<D, S> requirement : this.requirements) {
            if (requirement.test(sender, meta, senderMapper)) continue;
            return requirement;
        }
        return null;
    }
}

