/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.extention;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libs.dev.triumphteam.cmd.core.command.CommandExecutor;
import libs.dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import libs.dev.triumphteam.cmd.core.extention.CommandExtensions;
import libs.dev.triumphteam.cmd.core.extention.annotation.AnnotationProcessor;
import libs.dev.triumphteam.cmd.core.extention.argument.ArgumentValidator;
import libs.dev.triumphteam.cmd.core.extention.command.Processor;
import libs.dev.triumphteam.cmd.core.extention.sender.SenderExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ExtensionBuilder<D, S> {
    private final Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>> annotationProcessors = new HashMap<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>>();
    private final List<Processor<D, S>> processors = new ArrayList<Processor<D, S>>();
    private SenderExtension<D, S> senderExtension = null;
    private ArgumentValidator<S> argumentValidator = null;
    private CommandExecutor commandExecutor = null;

    @Contract(value="_, _ -> this")
    @NotNull
    public <A extends Annotation> ExtensionBuilder<D, S> addAnnotationProcessor(Class<A> annotation, @NotNull AnnotationProcessor<A> annotationProcessor) {
        this.annotationProcessors.put(annotation, annotationProcessor);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S> addProcessor(@NotNull Processor<D, S> processor) {
        this.processors.add(processor);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S> setArgumentValidator(@NotNull ArgumentValidator<S> argumentValidator) {
        this.argumentValidator = argumentValidator;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S> setCommandExecutor(@NotNull CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ExtensionBuilder<D, S> setSenderExtension(@NotNull SenderExtension<D, S> senderExtension) {
        this.senderExtension = senderExtension;
        return this;
    }

    @NotNull
    public CommandExtensions<D, S> build(@NotNull SenderExtension<D, S> defaultExtension) {
        if (this.argumentValidator == null) {
            throw new CommandRegistrationException("No argument validator was added to Command Manager.");
        }
        if (this.commandExecutor == null) {
            throw new CommandRegistrationException("No command executor was added to Command Manager.");
        }
        return new CommandExtensions<D, S>(this.senderExtension == null ? defaultExtension : this.senderExtension, this.annotationProcessors, this.processors, this.argumentValidator, this.commandExecutor);
    }
}

