/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.extention;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import libs.dev.triumphteam.cmd.core.argument.ArgumentResolver;
import libs.dev.triumphteam.cmd.core.argument.keyed.Argument;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentKey;
import libs.dev.triumphteam.cmd.core.argument.keyed.Flag;
import libs.dev.triumphteam.cmd.core.argument.keyed.FlagKey;
import libs.dev.triumphteam.cmd.core.extention.CommandExtensions;
import libs.dev.triumphteam.cmd.core.extention.ExtensionBuilder;
import libs.dev.triumphteam.cmd.core.extention.registry.ArgumentRegistry;
import libs.dev.triumphteam.cmd.core.extention.registry.FlagRegistry;
import libs.dev.triumphteam.cmd.core.extention.registry.MessageRegistry;
import libs.dev.triumphteam.cmd.core.extention.registry.NamedArgumentRegistry;
import libs.dev.triumphteam.cmd.core.extention.registry.RegistryContainer;
import libs.dev.triumphteam.cmd.core.extention.sender.SenderExtension;
import libs.dev.triumphteam.cmd.core.message.MessageKey;
import libs.dev.triumphteam.cmd.core.message.MessageResolver;
import libs.dev.triumphteam.cmd.core.message.context.MessageContext;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionRegistry;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CommandOptions<D, S> {
    private final CommandExtensions<D, S> commandExtensions;
    private final boolean suggestLowercaseEnum;

    public CommandOptions(@NotNull SenderExtension<D, S> senderExtension, @NotNull Builder<D, S, ?, ?, ?> builder) {
        this.commandExtensions = ((Builder)builder).extensionBuilder.build(senderExtension);
        this.suggestLowercaseEnum = ((Builder)builder).suggestLowercaseEnum;
    }

    @NotNull
    public CommandExtensions<D, S> getCommandExtensions() {
        return this.commandExtensions;
    }

    public boolean suggestLowercaseEnum() {
        return this.suggestLowercaseEnum;
    }

    public static abstract class Builder<D, S, O extends CommandOptions<D, S>, I extends Setup<D, S, I>, B extends Builder<D, S, O, I, B>> {
        private boolean suggestLowercaseEnum = false;
        private final ExtensionBuilder<D, S> extensionBuilder = new ExtensionBuilder();
        private final I setup;

        public Builder(@NotNull I setup) {
            this.setup = setup;
        }

        @Contract(value="_ -> this")
        @NotNull
        public B setup(@NotNull Consumer<I> consumer) {
            consumer.accept(this.setup);
            return (B)this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public B extensions(@NotNull Consumer<ExtensionBuilder<D, S>> consumer) {
            consumer.accept(this.extensionBuilder);
            return (B)this;
        }

        @Contract(value=" -> this")
        @NotNull
        public B suggestLowercaseEnum() {
            this.suggestLowercaseEnum = true;
            return (B)this;
        }

        @NotNull
        public abstract O build(@NotNull SenderExtension<D, S> var1);
    }

    public static abstract class Setup<D, S, I extends Setup<D, S, I>> {
        private final RegistryContainer<D, S> registryContainer;
        private final MessageRegistry<S> messageRegistry;
        private final SuggestionRegistry<S> suggestionRegistry;
        private final ArgumentRegistry<S> argumentRegistry;
        private final NamedArgumentRegistry namedArgumentRegistry;
        private final FlagRegistry flagRegistry;

        public Setup(@NotNull RegistryContainer<D, S> registryContainer) {
            this.registryContainer = registryContainer;
            this.messageRegistry = registryContainer.getMessageRegistry();
            this.suggestionRegistry = registryContainer.getSuggestionRegistry();
            this.argumentRegistry = registryContainer.getArgumentRegistry();
            this.namedArgumentRegistry = registryContainer.getNamedArgumentRegistry();
            this.flagRegistry = registryContainer.getFlagRegistry();
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public <C extends MessageContext> I message(@NotNull MessageKey<C> messageKey, @NotNull MessageResolver<S, C> resolver) {
            this.messageRegistry.register(messageKey, resolver);
            return (I)this;
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public I argument(@NotNull Class<?> type, @NotNull ArgumentResolver<S> resolver) {
            this.argumentRegistry.register(type, resolver);
            return (I)this;
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public I suggestion(@NotNull Class<?> type, @NotNull SuggestionResolver<S> resolver) {
            this.suggestionRegistry.register(type, resolver, SuggestionMethod.STARTS_WITH);
            return (I)this;
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public I suggestion(@NotNull SuggestionKey key, @NotNull SuggestionResolver<S> resolver) {
            this.suggestionRegistry.register(key, resolver, SuggestionMethod.STARTS_WITH);
            return (I)this;
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public I namedArguments(@NotNull ArgumentKey key, @NotNull List<Argument> arguments) {
            this.namedArgumentRegistry.register(key, arguments);
            return (I)this;
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public I namedArguments(@NotNull ArgumentKey key, Argument ... arguments) {
            return this.namedArguments(key, Arrays.asList(arguments));
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public I flags(@NotNull FlagKey key, @NotNull List<Flag> flags) {
            this.flagRegistry.register(key, flags);
            return (I)this;
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public I flags(@NotNull FlagKey key, Flag ... flags) {
            return this.flags(key, Arrays.asList(flags));
        }

        @NotNull
        protected RegistryContainer<D, S> getRegistryContainer() {
            return this.registryContainer;
        }
    }
}

