/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.command;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import libs.dev.triumphteam.cmd.core.annotations.Syntax;
import libs.dev.triumphteam.cmd.core.argument.InternalArgument;
import libs.dev.triumphteam.cmd.core.argument.LimitlessInternalArgument;
import libs.dev.triumphteam.cmd.core.argument.StringInternalArgument;
import libs.dev.triumphteam.cmd.core.command.Command;
import libs.dev.triumphteam.cmd.core.command.CommandExecutor;
import libs.dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import libs.dev.triumphteam.cmd.core.extention.CommandOptions;
import libs.dev.triumphteam.cmd.core.extention.Result;
import libs.dev.triumphteam.cmd.core.extention.ValidationResult;
import libs.dev.triumphteam.cmd.core.extention.command.Settings;
import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.extention.registry.MessageRegistry;
import libs.dev.triumphteam.cmd.core.extention.sender.SenderExtension;
import libs.dev.triumphteam.cmd.core.message.MessageKey;
import libs.dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import libs.dev.triumphteam.cmd.core.message.context.MessageContext;
import libs.dev.triumphteam.cmd.core.message.context.SyntaxMessageContext;
import libs.dev.triumphteam.cmd.core.processor.CommandProcessor;
import libs.dev.triumphteam.cmd.core.processor.SubCommandProcessor;
import libs.dev.triumphteam.cmd.core.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubCommand<D, S>
implements Command<D, S> {
    private final Class<? extends S> senderType;
    private final List<InternalArgument<S, ?>> argumentList;
    private final Map<String, InternalArgument<S, ?>> argumentMap;
    private final String name;
    private final List<String> aliases;
    private final String description;
    private final String syntax;
    private final boolean containsLimitless;
    private final CommandMeta meta;
    private final Settings<D, S> settings;
    private final Object invocationInstance;
    private final Method method;
    private final CommandExecutor commandExecutor;
    private final SenderExtension<D, S> senderExtension;
    private final MessageRegistry<S> messageRegistry;

    public SubCommand(@NotNull Object invocationInstance, @NotNull Method method, @NotNull SubCommandProcessor<D, S> processor, @NotNull Command<D, S> parentCommand) {
        this.invocationInstance = invocationInstance;
        this.method = method;
        this.name = processor.getName();
        this.description = processor.getDescription();
        this.aliases = processor.getAliases();
        Settings.Builder settingsBuilder = new Settings.Builder();
        processor.captureRequirements(settingsBuilder);
        this.meta = processor.createMeta(settingsBuilder);
        this.senderType = processor.senderType();
        this.argumentList = processor.arguments(this.meta);
        this.argumentMap = this.argumentList.stream().map(argument -> new Pair<String, InternalArgument>(argument.getName(), (InternalArgument)argument)).collect(Collectors.toMap(Pair::first, Pair::second));
        this.containsLimitless = this.argumentList.stream().anyMatch(LimitlessInternalArgument.class::isInstance);
        CommandOptions commandOptions = processor.getCommandOptions();
        this.messageRegistry = processor.getRegistryContainer().getMessageRegistry();
        this.senderExtension = commandOptions.getCommandExtensions().getSenderExtension();
        this.commandExecutor = commandOptions.getCommandExtensions().getCommandExecutor();
        this.syntax = this.createSyntax(parentCommand, processor);
        this.settings = settingsBuilder.build();
    }

    @Override
    public void execute(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Deque<String> arguments) throws Throwable {
        ValidationResult<MessageKey<MessageContext>> validationResult = this.senderExtension.validate(this.meta, this.senderType, sender);
        if (validationResult instanceof ValidationResult.Invalid) {
            this.messageRegistry.sendMessage((MessageKey)((ValidationResult.Invalid)validationResult).getMessage(), sender, new SyntaxMessageContext(this.meta, this.syntax));
            return;
        }
        if (!this.settings.testRequirements(this.messageRegistry, sender, this.meta, this.senderExtension)) {
            return;
        }
        ArrayList<Object> invokeArguments = new ArrayList<Object>();
        invokeArguments.add(sender);
        if (!this.validateAndCollectArguments(sender, invokeArguments, arguments)) {
            return;
        }
        if (!this.containsLimitless && arguments.size() >= invokeArguments.size()) {
            this.messageRegistry.sendMessage(MessageKey.TOO_MANY_ARGUMENTS, sender, new SyntaxMessageContext(this.meta, this.syntax));
            return;
        }
        this.commandExecutor.execute(this.meta, instanceSupplier == null ? this.invocationInstance : instanceSupplier.get(), this.method, invokeArguments);
    }

    @Override
    public void executeNonLinear(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Deque<String> commands, @NotNull Map<String, Pair<String, Object>> arguments) throws Throwable {
        ValidationResult<MessageKey<MessageContext>> validationResult = this.senderExtension.validate(this.meta, this.senderType, sender);
        if (validationResult instanceof ValidationResult.Invalid) {
            this.messageRegistry.sendMessage((MessageKey)((ValidationResult.Invalid)validationResult).getMessage(), sender, new SyntaxMessageContext(this.meta, this.syntax));
            return;
        }
        if (!this.settings.testRequirements(this.messageRegistry, sender, this.meta, this.senderExtension)) {
            return;
        }
        ArrayList<Object> invokeArguments = new ArrayList<Object>();
        invokeArguments.add(sender);
        this.argumentList.forEach(it -> {
            Pair pair = (Pair)arguments.get(it.getName());
            if (pair == null) {
                invokeArguments.add(null);
                return;
            }
            ArrayDeque<String> raw = it instanceof LimitlessInternalArgument ? new ArrayDeque<String>(Arrays.asList(((String)pair.first()).split(""))) : new ArrayDeque<String>(Collections.singleton((String)pair.first()));
            this.validateAndCollectArgument(sender, (List<Object>)invokeArguments, (Deque<String>)raw, (InternalArgument<S, ?>)it, pair.second());
        });
        this.commandExecutor.execute(this.meta, instanceSupplier == null ? this.invocationInstance : instanceSupplier.get(), this.method, invokeArguments);
    }

    @Override
    @NotNull
    public List<String> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        if (arguments.isEmpty()) {
            return Collections.emptyList();
        }
        int index = arguments.size() - 1;
        InternalArgument<S, ?> argument = this.getArgumentFromIndex(index);
        if (argument == null) {
            return Collections.emptyList();
        }
        return argument.suggestions(sender, arguments);
    }

    @Nullable
    public InternalArgument<S, ?> getArgumentFromIndex(int index) {
        if (!this.hasArguments()) {
            return null;
        }
        int size = this.argumentList.size();
        if (index >= size) {
            InternalArgument<S, ?> last = this.argumentList.get(size - 1);
            if (last instanceof LimitlessInternalArgument) {
                return last;
            }
            return null;
        }
        return this.argumentList.get(index);
    }

    @NotNull
    public List<String> suggest(@NotNull S sender, @NotNull String name, @NotNull String value) {
        InternalArgument<S, ?> argument = this.getArgumentFromName(name);
        if (argument == null) {
            return Collections.emptyList();
        }
        return argument.suggestions(sender, new ArrayDeque<String>(Collections.singleton(value)));
    }

    @Nullable
    private InternalArgument<S, ?> getArgumentFromName(@NotNull String name) {
        return this.argumentMap.get(name);
    }

    private boolean validateAndCollectArguments(@NotNull S sender, @NotNull List<Object> invokeArguments, @NotNull Deque<String> commandArgs) {
        for (InternalArgument<S, ?> internalArgument : this.argumentList) {
            if (this.validateAndCollectArgument(sender, invokeArguments, commandArgs, internalArgument, null)) continue;
            return false;
        }
        return true;
    }

    private boolean validateAndCollectArgument(@NotNull S sender, @NotNull List<Object> invokeArguments, @NotNull Deque<String> commandArgs, @NotNull InternalArgument<S, ?> internalArgument, @Nullable Object provided) {
        Result<Object, BiFunction<CommandMeta, String, InvalidArgumentContext>> result;
        if (internalArgument instanceof LimitlessInternalArgument) {
            LimitlessInternalArgument limitlessArgument = (LimitlessInternalArgument)internalArgument;
            result = limitlessArgument.resolve(sender, commandArgs, provided);
        } else if (internalArgument instanceof StringInternalArgument) {
            StringInternalArgument stringArgument = (StringInternalArgument)internalArgument;
            String arg = commandArgs.peek();
            if (arg == null || arg.isEmpty()) {
                if (internalArgument.isOptional()) {
                    invokeArguments.add(null);
                    return true;
                }
                this.messageRegistry.sendMessage(MessageKey.NOT_ENOUGH_ARGUMENTS, sender, new SyntaxMessageContext(this.meta, this.syntax));
                return false;
            }
            commandArgs.pop();
            result = stringArgument.resolve(sender, arg, provided);
        } else {
            throw new CommandExecutionException("Found unsupported argument", "", this.name);
        }
        if (result instanceof Result.Failure) {
            this.messageRegistry.sendMessage(MessageKey.INVALID_ARGUMENT, sender, (InvalidArgumentContext)((BiFunction)((Result.Failure)result).getFail()).apply(this.meta, this.syntax));
            return false;
        }
        if (result instanceof Result.Success) {
            invokeArguments.add(((Result.Success)result).getValue());
        }
        return true;
    }

    @NotNull
    private String createSyntax(@NotNull Command<D, S> parentCommand, @NotNull CommandProcessor<D, S> processor) {
        Syntax syntaxAnnotation = processor.getSyntaxAnnotation();
        if (syntaxAnnotation != null) {
            return syntaxAnnotation.value();
        }
        StringBuilder builder = new StringBuilder(parentCommand.getSyntax());
        if (!"th-default".equals(this.name)) {
            builder.append(" ").append(this.name);
        }
        this.argumentList.forEach(argument -> builder.append(" ").append("<").append(argument.getName()).append(">"));
        return builder.toString();
    }

    @Override
    @NotNull
    public CommandMeta getMeta() {
        return this.meta;
    }

    @Override
    @NotNull
    public Settings<D, S> getCommandSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @NotNull
    public String getSyntax() {
        return this.syntax;
    }

    @NotNull
    public List<InternalArgument<S, ?>> getArgumentList() {
        return this.argumentList;
    }

    @NotNull
    public Map<String, InternalArgument<S, ?>> getArgumentMap() {
        return this.argumentMap;
    }

    @Override
    public boolean isDefault() {
        return this.name.equals("th-default");
    }

    @Override
    public boolean hasArguments() {
        return !this.argumentList.isEmpty();
    }
}

