/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument.keyed;

import java.util.Objects;
import libs.dev.triumphteam.cmd.core.argument.keyed.Argument;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SimpleArgument
implements Argument {
    private final String name;
    private final Class<?> type;
    private final String description;
    private final SuggestionKey suggestionKey;

    public SimpleArgument(@NotNull Argument.AbstractBuilder<?> argumentBuilder) {
        this.type = argumentBuilder.getType();
        this.name = argumentBuilder.getName();
        this.description = argumentBuilder.getDescription();
        this.suggestionKey = argumentBuilder.getSuggestionKey();
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public SuggestionKey getSuggestion() {
        return this.suggestionKey;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleArgument that = (SimpleArgument)o;
        return this.type.equals(that.type) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    public String toString() {
        return "SimpleArgument{name='" + this.name + '\'' + ", type=" + this.type + '}';
    }
}

