/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument.keyed;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import libs.dev.triumphteam.cmd.core.argument.keyed.Argument;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NamedGroup
implements ArgumentGroup<Argument> {
    private final Map<String, Argument> arguments = new HashMap<String, Argument>();

    NamedGroup(@NotNull List<Argument> arguments) {
        arguments.forEach(this::addArgument);
    }

    public void addArgument(@NotNull Argument argument) {
        this.arguments.put(argument.getName(), argument);
    }

    @Override
    @NotNull
    public Set<String> getAllNames() {
        return this.arguments.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.arguments.isEmpty();
    }

    @Override
    @Nullable
    public Argument matchExact(@NotNull String token) {
        return this.arguments.get(token);
    }

    @Override
    @Nullable
    public Argument matchPartialSingle(@NotNull String token) {
        List arguments = this.arguments.entrySet().stream().filter(it -> ((String)it.getKey()).startsWith(token)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (arguments.size() != 1) {
            return null;
        }
        return (Argument)arguments.get(0);
    }

    @Override
    @NotNull
    public Set<Argument> getAll() {
        return new HashSet<Argument>(this.arguments.values());
    }
}

