/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument.keyed;

import java.util.Objects;
import libs.dev.triumphteam.cmd.core.argument.keyed.Argument;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListArgument
implements Argument {
    private final String name;
    private final Class<?> collectionType;
    private final String separator;
    private final Class<?> type;
    private final String description;
    private final SuggestionKey suggestionKey;

    public ListArgument(@NotNull Argument.CollectionBuilder argumentBuilder) {
        this.type = argumentBuilder.getType();
        this.name = argumentBuilder.getName();
        this.description = argumentBuilder.getDescription();
        this.suggestionKey = argumentBuilder.getSuggestionKey();
        this.collectionType = argumentBuilder.getCollectionType();
        this.separator = argumentBuilder.getSeparator();
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public SuggestionKey getSuggestion() {
        return this.suggestionKey;
    }

    @NotNull
    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    @NotNull
    public String getSeparator() {
        return this.separator;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListArgument that = (ListArgument)o;
        return this.collectionType.equals(that.collectionType) && this.separator.equals(that.separator) && this.type.equals(that.type) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.collectionType, this.separator, this.type, this.name);
    }

    public String toString() {
        return "ListArgument{name='" + this.name + '\'' + ", collectionType=" + this.collectionType + ", separator='" + this.separator + '\'' + ", type=" + this.type + '}';
    }
}

