/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument.keyed;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import libs.dev.triumphteam.cmd.core.argument.InternalArgument;
import libs.dev.triumphteam.cmd.core.argument.LimitlessInternalArgument;
import libs.dev.triumphteam.cmd.core.argument.StringInternalArgument;
import libs.dev.triumphteam.cmd.core.argument.keyed.Argument;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentParser;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentValue;
import libs.dev.triumphteam.cmd.core.argument.keyed.EmptyArgumentValue;
import libs.dev.triumphteam.cmd.core.argument.keyed.Flag;
import libs.dev.triumphteam.cmd.core.argument.keyed.Flags;
import libs.dev.triumphteam.cmd.core.argument.keyed.KeyedArguments;
import libs.dev.triumphteam.cmd.core.argument.keyed.SimpleArgumentValue;
import libs.dev.triumphteam.cmd.core.extention.Result;
import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import libs.dev.triumphteam.cmd.core.suggestion.EmptySuggestion;
import libs.dev.triumphteam.cmd.core.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeyedInternalArgument<S>
extends LimitlessInternalArgument<S> {
    private final Map<Flag, StringInternalArgument<S>> flagInternalArguments;
    private final Map<Argument, StringInternalArgument<S>> argumentInternalArguments;
    private final ArgumentParser argumentParser;

    public KeyedInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull Map<Flag, StringInternalArgument<S>> flagInternalArguments, @NotNull Map<Argument, StringInternalArgument<S>> argumentInternalArguments, @NotNull ArgumentGroup<Flag> flagGroup, @NotNull ArgumentGroup<Argument> argumentGroup) {
        super(meta, name, description, Flags.class, new EmptySuggestion(), true);
        this.flagInternalArguments = flagInternalArguments;
        this.argumentInternalArguments = argumentInternalArguments;
        this.argumentParser = new ArgumentParser(flagGroup, argumentGroup);
    }

    @Override
    @NotNull
    public @NotNull Result<@Nullable Object, BiFunction<@NotNull CommandMeta, @NotNull String, @NotNull InvalidArgumentContext>> resolve(@NotNull S sender, @NotNull Collection<String> value, @Nullable Object provided) {
        ArgumentParser.Result result = this.argumentParser.parse(value);
        HashMap<String, ArgumentValue> arguments = new HashMap<String, ArgumentValue>();
        for (Map.Entry<Argument, String> entry : result.getNamedArguments().entrySet()) {
            Argument argument = entry.getKey();
            String raw = entry.getValue();
            StringInternalArgument<S> internalArgument = this.argumentInternalArguments.get(argument);
            if (internalArgument == null) continue;
            Result<@Nullable Object, BiFunction<@NotNull CommandMeta, @NotNull String, @NotNull InvalidArgumentContext>> resolved = internalArgument.resolve(sender, entry.getValue());
            if (resolved instanceof Result.Failure) {
                return resolved;
            }
            if (!(resolved instanceof Result.Success)) continue;
            Object resolvedValue = ((Result.Success)resolved).getValue();
            arguments.put(argument.getName(), new SimpleArgumentValue(raw, resolvedValue));
        }
        HashMap<String, ArgumentValue> flags = new HashMap<String, ArgumentValue>();
        for (Map.Entry<Flag, String> entry : result.getFlags().entrySet()) {
            Flag flag = entry.getKey();
            String raw = entry.getValue();
            if (!flag.hasArgument()) {
                flags.put(flag.getFlag(), EmptyArgumentValue.INSTANCE);
                flags.put(flag.getLongFlag(), EmptyArgumentValue.INSTANCE);
                continue;
            }
            StringInternalArgument<S> internalArgument = this.flagInternalArguments.get(flag);
            if (internalArgument == null) continue;
            Result<@Nullable Object, BiFunction<@NotNull CommandMeta, @NotNull String, @NotNull InvalidArgumentContext>> resolved = internalArgument.resolve(sender, entry.getValue());
            if (resolved instanceof Result.Failure) {
                return resolved;
            }
            if (!(resolved instanceof Result.Success)) continue;
            Object resolvedValue = ((Result.Success)resolved).getValue();
            SimpleArgumentValue argumentValue = new SimpleArgumentValue(raw, resolvedValue);
            flags.put(flag.getFlag(), argumentValue);
            flags.put(flag.getLongFlag(), argumentValue);
        }
        return this.success(new KeyedArguments(arguments, flags, result.getNonTokens()));
    }

    @Override
    @NotNull
    public List<String> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        String last = arguments.peekLast();
        String current = last == null ? "" : last;
        ArgumentParser.Result result = this.argumentParser.parse(arguments);
        String resultCurrent = result.getCurrent();
        List<String> waitingFlagArguments = this.handleFlagArgument(resultCurrent, result, sender);
        if (waitingFlagArguments != null) {
            return waitingFlagArguments;
        }
        List<String> waitingArguments = this.handleNamedArgument(resultCurrent, result, sender);
        if (waitingArguments != null) {
            return waitingArguments;
        }
        if (current.startsWith("--")) {
            return this.longFlags(resultCurrent, result.getFlags());
        }
        if (current.startsWith("-")) {
            return this.flags(resultCurrent, result.getFlags());
        }
        return this.namedArguments(resultCurrent, result.getNamedArguments());
    }

    @NotNull
    private List<String> longFlags(@NotNull String current, @NotNull Map<Flag, String> parsed) {
        return this.flagInternalArguments.keySet().stream().filter(it -> !parsed.containsKey(it)).map(Flag::getLongFlag).filter(Objects::nonNull).map(it -> "--" + it).filter(it -> it.startsWith(current)).collect(Collectors.toList());
    }

    @NotNull
    private List<String> flags(@NotNull String current, @NotNull Map<Flag, String> parsed) {
        return this.flagInternalArguments.keySet().stream().filter(it -> !parsed.containsKey(it)).map(Flag::getFlag).filter(Objects::nonNull).map(it -> "-" + it).filter(it -> it.startsWith(current)).collect(Collectors.toList());
    }

    @NotNull
    private List<String> namedArguments(@NotNull String current, @NotNull Map<Argument, String> parsed) {
        return this.argumentInternalArguments.keySet().stream().filter(it -> !parsed.containsKey(it)).map(Argument::getName).filter(it -> it.startsWith(current)).map(it -> it + ":").collect(Collectors.toList());
    }

    @Nullable
    private List<String> handleNamedArgument(@NotNull String current, @NotNull ArgumentParser.Result result, @NotNull S sender) {
        Argument waiting = result.getArgumentWaiting();
        if (waiting == null) {
            return null;
        }
        InternalArgument internalArgument = this.argumentInternalArguments.get(waiting);
        if (internalArgument == null) {
            return null;
        }
        String raw = waiting.getName() + ":";
        List<String> suggestions = internalArgument.suggestions(sender, new ArrayDeque<String>(Collections.singleton(current))).stream().map(it -> raw + it).collect(Collectors.toList());
        if (suggestions.isEmpty()) {
            return Collections.singletonList(raw);
        }
        return suggestions;
    }

    @Nullable
    private List<String> handleFlagArgument(@NotNull String current, @NotNull ArgumentParser.Result result, @NotNull S sender) {
        Pair<Flag, ArgumentParser.Result.FlagType> waitingFlag = result.getFlagWaiting();
        if (waitingFlag == null) {
            return null;
        }
        Flag flag = waitingFlag.first();
        ArgumentParser.Result.FlagType type = waitingFlag.second();
        InternalArgument internalArgument = this.flagInternalArguments.get(flag);
        if (internalArgument == null) {
            return null;
        }
        return internalArgument.suggestions(sender, new ArrayDeque<String>(Collections.singleton(current))).stream().map(it -> {
            if (!type.hasEquals()) {
                return it;
            }
            String prefix = type.isLong() ? "--" + flag.getLongFlag() : "-" + flag.getFlag();
            return prefix + "=" + it;
        }).collect(Collectors.toList());
    }
}

