/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument.keyed;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentValue;
import libs.dev.triumphteam.cmd.core.argument.keyed.Arguments;
import libs.dev.triumphteam.cmd.core.argument.keyed.SimpleArgumentValue;
import org.jetbrains.annotations.NotNull;

abstract class FlagsContainer
implements Arguments {
    private final Map<String, ArgumentValue> flags;

    public FlagsContainer(@NotNull Map<String, ArgumentValue> flags) {
        this.flags = flags;
    }

    @Override
    public boolean hasFlag(@NotNull String flag) {
        return this.flags.containsKey(flag);
    }

    @Override
    @NotNull
    public <T> Optional<T> getFlagValue(@NotNull String flag, @NotNull Class<T> type) {
        ArgumentValue flagValue = this.flags.get(flag);
        if (flagValue == null) {
            return Optional.empty();
        }
        if (!(flagValue instanceof SimpleArgumentValue)) {
            return Optional.empty();
        }
        SimpleArgumentValue argFlagValue = (SimpleArgumentValue)flagValue;
        return Optional.ofNullable(argFlagValue.getValue());
    }

    @Override
    @NotNull
    public Optional<String> getFlagValue(@NotNull String flag) {
        ArgumentValue flagValue = this.flags.get(flag);
        if (flagValue == null) {
            return Optional.empty();
        }
        if (!(flagValue instanceof SimpleArgumentValue)) {
            return Optional.empty();
        }
        SimpleArgumentValue argFlagValue = (SimpleArgumentValue)flagValue;
        return Optional.of(argFlagValue.getAsString());
    }

    @Override
    @NotNull
    public Set<String> getAllFlags() {
        return this.flags.keySet();
    }

    @Override
    public boolean hasFlags() {
        return !this.flags.isEmpty();
    }

    public String toString() {
        return "FlagsContainer{flags=" + this.flags + '}';
    }
}

