/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument.keyed;

import libs.dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import org.jetbrains.annotations.Nullable;

final class FlagValidator {
    private FlagValidator() {
        throw new AssertionError((Object)"Util class must not be initialized.");
    }

    static void validate(@Nullable String flag) {
        if (flag == null) {
            return;
        }
        if (flag.length() == 1) {
            char character = flag.charAt(0);
            if (!FlagValidator.isValidFlag(character)) {
                throw new CommandRegistrationException("Illegal flag name \"" + character + "\" on flag \"" + flag + "\".");
            }
            return;
        }
        for (char character : flag.toCharArray()) {
            if (FlagValidator.isValidChar(character)) continue;
            throw new CommandRegistrationException("The flag \"" + flag + "\" contains an illegal character \"" + character + "\".");
        }
    }

    private static boolean isValidFlag(char c) {
        return FlagValidator.isValidChar(c) || c == '?' || c == '@';
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }
}

