/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument.keyed;

import libs.dev.triumphteam.cmd.core.argument.keyed.FlagOptions;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Flag {
    @Contract(value="_ -> new")
    @NotNull
    public static Builder flag(@NotNull String flag) {
        return new Builder().flag(flag);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Builder longFlag(@NotNull String longFlag) {
        return new Builder().longFlag(longFlag);
    }

    @Nullable
    public String getFlag();

    @Nullable
    public String getLongFlag();

    @NotNull
    public String getKey();

    @NotNull
    public String getDescription();

    @Nullable
    public SuggestionKey getSuggestion();

    public boolean hasArgument();

    @Nullable
    public Class<?> getArgument();

    public static final class Builder {
        private String flag;
        private String longFlag;
        private String description;
        private Class<?> argument;
        private SuggestionKey suggestionKey;

        @Contract(value="_ -> this")
        @NotNull
        public Builder flag(@NotNull String flag) {
            this.flag = flag;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder longFlag(@NotNull String longFlag) {
            this.longFlag = longFlag;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder description(@NotNull String description) {
            this.description = description;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder argument(@NotNull Class<?> argumentType) {
            this.argument = argumentType;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder suggestion(@NotNull SuggestionKey suggestionKey) {
            this.suggestionKey = suggestionKey;
            return this;
        }

        @Contract(value=" -> new")
        @NotNull
        public Flag build() {
            return new FlagOptions(this);
        }

        @NotNull
        Class<?> getArgument() {
            return this.argument;
        }

        @NotNull
        String getFlag() {
            return this.flag;
        }

        @NotNull
        String getLongFlag() {
            return this.longFlag;
        }

        @NotNull
        String getDescription() {
            return this.description;
        }

        @Nullable
        SuggestionKey getSuggestionKey() {
            return this.suggestionKey;
        }
    }
}

