/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument.keyed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import libs.dev.triumphteam.cmd.core.argument.keyed.Argument;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import libs.dev.triumphteam.cmd.core.argument.keyed.Flag;
import libs.dev.triumphteam.cmd.core.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ArgumentParser {
    private static final String LONG = "--";
    private static final String SHORT = "-";
    private static final String ESCAPE = "\\";
    private static final int ARGUMENT_SEPARATOR = 58;
    private static final int FLAG_SEPARATOR = 61;
    private final ArgumentGroup<Flag> flagGroup;
    private final ArgumentGroup<Argument> namedGroup;

    public ArgumentParser(@NotNull ArgumentGroup<Flag> flagGroup, @NotNull ArgumentGroup<Argument> namedGroup) {
        this.flagGroup = flagGroup;
        this.namedGroup = namedGroup;
    }

    public Result parse(@NotNull Collection<String> arguments) {
        Iterator<String> tokens = arguments.iterator();
        Result result = new Result();
        boolean pendingResultReset = false;
        while (tokens.hasNext()) {
            String token;
            result.setArgumentWaiting(null);
            result.setCurrent("");
            if (pendingResultReset) {
                pendingResultReset = false;
                result.setFlagWaiting(null);
            }
            if ((token = tokens.next()).startsWith(ESCAPE)) {
                result.addNonToken(token);
                continue;
            }
            Pair<Flag, Result.FlagType> waitingFlag = result.getFlagWaiting();
            if (waitingFlag != null) {
                result.addFlag(waitingFlag.first(), token);
                result.setCurrent(token);
                pendingResultReset = true;
                continue;
            }
            if (!(token.startsWith(LONG) && !LONG.equals(token) || token.startsWith(SHORT) && !SHORT.equals(token))) {
                int separator = token.indexOf(58);
                if (separator == -1) {
                    Argument partial = this.namedGroup.matchPartialSingle(token);
                    if (partial != null) {
                        result.setArgumentWaiting(partial);
                    }
                    result.addNonToken(token);
                    continue;
                }
                this.handleNamed(result, token, separator);
                continue;
            }
            int equals = token.indexOf(61);
            if (equals == -1) {
                this.handleNoEquals(result, token);
                continue;
            }
            this.handleWithEquals(result, token, equals);
            pendingResultReset = true;
        }
        return result;
    }

    private void handleNamed(@NotNull Result result, @NotNull String token, int separator) {
        String namedToken = token.substring(0, separator);
        String argToken = token.substring(separator + 1);
        Argument argument = this.namedGroup.matchExact(namedToken);
        if (argument == null) {
            result.addNonToken(token);
            return;
        }
        result.addNamedArgument(argument, argToken);
        result.setCurrent(argToken);
        result.setArgumentWaiting(argument);
    }

    private void handleNoEquals(@NotNull Result result, @NotNull String token) {
        Flag flag = this.flagGroup.matchExact(token);
        if (flag == null) {
            result.addNonToken(token);
            return;
        }
        if (flag.hasArgument()) {
            Result.FlagType type = token.startsWith(LONG) ? Result.FlagType.LONG_NO_EQUALS : Result.FlagType.FLAG_NO_EQUALS;
            result.setFlagWaiting(new Pair<Flag, Result.FlagType>(flag, type));
            result.setCurrent(token);
            return;
        }
        result.addFlag(flag);
    }

    private void handleWithEquals(@NotNull Result result, @NotNull String token, int equals) {
        String flagToken = token.substring(0, equals);
        String argToken = token.substring(equals + 1);
        Flag flag = this.flagGroup.matchExact(flagToken);
        if (flag == null) {
            result.addNonToken(token);
            return;
        }
        if (!flag.hasArgument()) {
            result.addNonToken(token);
            return;
        }
        result.addFlag(flag, argToken);
        result.setCurrent(argToken);
        Result.FlagType type = token.startsWith(LONG) ? Result.FlagType.LONG : Result.FlagType.FLAG;
        result.setFlagWaiting(new Pair<Flag, Result.FlagType>(flag, type), true);
    }

    public static class Result {
        private final Map<Flag, String> flags = new HashMap<Flag, String>();
        private final Map<Argument, String> namedArguments = new HashMap<Argument, String>();
        private final List<String> nonTokens = new ArrayList<String>();
        private String current = "";
        private Argument argumentWaiting = null;
        private Pair<Flag, FlagType> flagWaiting = null;

        public void addNamedArgument(@NotNull Argument argument, @NotNull String value) {
            this.namedArguments.put(argument, value);
        }

        public void addFlag(@NotNull Flag flagOptions) {
            this.flags.put(flagOptions, "");
        }

        public void addFlag(@NotNull Flag flagOptions, @NotNull String value) {
            this.flags.put(flagOptions, value);
        }

        public void addNonToken(@NotNull String token) {
            this.nonTokens.add(token);
        }

        public Map<Flag, String> getFlags() {
            return this.flags;
        }

        public Map<Argument, String> getNamedArguments() {
            return this.namedArguments;
        }

        public List<String> getNonTokens() {
            return this.nonTokens;
        }

        @Nullable
        public Argument getArgumentWaiting() {
            return this.argumentWaiting;
        }

        public void setArgumentWaiting(@Nullable Argument argumentWaiting) {
            this.argumentWaiting = argumentWaiting;
        }

        @Nullable
        public Pair<Flag, FlagType> getFlagWaiting() {
            return this.flagWaiting;
        }

        public void setFlagWaiting(@Nullable Pair<Flag, FlagType> flagWaiting) {
            this.setFlagWaiting(flagWaiting, false);
        }

        public void setFlagWaiting(@Nullable Pair<Flag, FlagType> flagWaiting, boolean ignore) {
            if (!ignore && flagWaiting != null && this.flags.containsKey(flagWaiting.first())) {
                return;
            }
            this.flagWaiting = flagWaiting;
        }

        @NotNull
        public String getCurrent() {
            return this.current;
        }

        public void setCurrent(@NotNull String current) {
            this.current = current;
        }

        public static enum FlagType {
            FLAG,
            FLAG_NO_EQUALS,
            LONG,
            LONG_NO_EQUALS;


            public boolean isLong() {
                return this == LONG || this == LONG_NO_EQUALS;
            }

            public boolean hasEquals() {
                return this == FLAG || this == LONG;
            }
        }
    }
}

