/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument;

import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import libs.dev.triumphteam.cmd.core.argument.InternalArgument;
import libs.dev.triumphteam.cmd.core.argument.LimitlessInternalArgument;
import libs.dev.triumphteam.cmd.core.extention.Result;
import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import libs.dev.triumphteam.cmd.core.suggestion.Suggestion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionInternalArgument<S>
extends LimitlessInternalArgument<S> {
    private final InternalArgument<S, String> internalArgument;
    private final Class<?> collectionType;

    public CollectionInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull InternalArgument<S, String> internalArgument, @NotNull Class<?> collectionType, @NotNull Suggestion<S> suggestion, boolean optional) {
        super(meta, name, description, String.class, suggestion, optional);
        this.internalArgument = internalArgument;
        this.collectionType = collectionType;
    }

    @Override
    @NotNull
    public @NotNull Result<@Nullable Object, BiFunction<@NotNull CommandMeta, @NotNull String, @NotNull InvalidArgumentContext>> resolve(@NotNull S sender, @NotNull Collection<String> value, @Nullable Object provided) {
        Stream<Object> stream = value.stream().map(arg -> this.internalArgument.resolve(sender, (String)arg));
        if (this.collectionType == Set.class) {
            return this.success(stream.collect(Collectors.toSet()));
        }
        return this.success(stream.collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public String toString() {
        return "CollectionArgument{collectionType=" + this.collectionType + ", super=" + super.toString() + "}";
    }
}

