/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core.argument;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import libs.dev.triumphteam.cmd.core.argument.InternalArgument;
import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.suggestion.EmptySuggestion;
import libs.dev.triumphteam.cmd.core.suggestion.Suggestion;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInternalArgument<S, T>
implements InternalArgument<S, T> {
    private final CommandMeta meta;
    private final String name;
    private final String description;
    private final Class<?> type;
    private final boolean optional;
    private final Suggestion<S> suggestion;

    public AbstractInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull Class<?> type, @NotNull Suggestion<S> suggestion, boolean optional) {
        this.meta = meta;
        this.name = name;
        this.description = description;
        this.type = type;
        this.suggestion = suggestion;
        this.optional = optional;
    }

    @Override
    @NotNull
    public List<String> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        String current = arguments.peekLast();
        return this.suggestion.getSuggestions(sender, current == null ? "" : current, new ArrayList<String>(arguments));
    }

    @Override
    @NotNull
    public CommandMeta getMeta() {
        return this.meta;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean canSuggest() {
        return !(this.suggestion instanceof EmptySuggestion);
    }

    @NotNull
    protected Suggestion<S> getSuggestion() {
        return this.suggestion;
    }

    @NotNull
    public String toString() {
        return "AbstractInternalArgument{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type=" + this.type + ", optional=" + this.optional + ", suggestion=" + this.suggestion + '}';
    }
}

