/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.core;

import java.util.Arrays;
import java.util.List;
import libs.dev.triumphteam.cmd.core.argument.ArgumentResolver;
import libs.dev.triumphteam.cmd.core.argument.InternalArgument;
import libs.dev.triumphteam.cmd.core.argument.keyed.Argument;
import libs.dev.triumphteam.cmd.core.argument.keyed.ArgumentKey;
import libs.dev.triumphteam.cmd.core.argument.keyed.Flag;
import libs.dev.triumphteam.cmd.core.argument.keyed.FlagKey;
import libs.dev.triumphteam.cmd.core.extention.CommandOptions;
import libs.dev.triumphteam.cmd.core.extention.registry.RegistryContainer;
import libs.dev.triumphteam.cmd.core.message.ContextualKey;
import libs.dev.triumphteam.cmd.core.message.MessageResolver;
import libs.dev.triumphteam.cmd.core.message.context.MessageContext;
import libs.dev.triumphteam.cmd.core.requirement.RequirementKey;
import libs.dev.triumphteam.cmd.core.requirement.RequirementResolver;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import libs.dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import org.jetbrains.annotations.NotNull;

public abstract class CommandManager<D, S, O extends CommandOptions<D, S>> {
    private final O commandOptions;

    public CommandManager(@NotNull O commandOptions) {
        this.commandOptions = commandOptions;
    }

    public abstract void registerCommand(@NotNull Object var1);

    public final void registerCommand(Object ... commands) {
        for (Object command : commands) {
            this.registerCommand(command);
        }
    }

    public abstract void unregisterCommand(@NotNull Object var1);

    public final void unregisterCommands(Object ... commands) {
        for (Object command : commands) {
            this.unregisterCommand(command);
        }
    }

    public final void registerArgument(@NotNull Class<?> clazz, @NotNull ArgumentResolver<S> resolver) {
        this.getRegistryContainer().getArgumentRegistry().register(clazz, resolver);
    }

    public final void registerArgument(@NotNull Class<?> clazz, @NotNull InternalArgument.Factory<S> factory) {
        this.getRegistryContainer().getArgumentRegistry().register(clazz, factory);
    }

    public void registerSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionResolver<S> resolver) {
        this.registerSuggestion(key, SuggestionMethod.STARTS_WITH, resolver);
    }

    public void registerSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionMethod method, @NotNull SuggestionResolver<S> resolver) {
        this.getRegistryContainer().getSuggestionRegistry().register(key, resolver, method);
    }

    public void registerSuggestion(@NotNull Class<?> type, @NotNull SuggestionResolver<S> resolver) {
        this.registerSuggestion(type, SuggestionMethod.STARTS_WITH, resolver);
    }

    public void registerSuggestion(@NotNull Class<?> type, @NotNull SuggestionMethod method, @NotNull SuggestionResolver<S> resolver) {
        this.getRegistryContainer().getSuggestionRegistry().register(type, resolver, method);
    }

    public final void registerNamedArguments(@NotNull ArgumentKey key, Argument ... arguments) {
        this.registerNamedArguments(key, Arrays.asList(arguments));
    }

    public final void registerNamedArguments(@NotNull ArgumentKey key, @NotNull List<Argument> arguments) {
        this.getRegistryContainer().getNamedArgumentRegistry().register(key, arguments);
    }

    public final void registerFlags(@NotNull FlagKey key, Flag ... flags) {
        this.registerFlags(key, Arrays.asList(flags));
    }

    public final void registerFlags(@NotNull FlagKey key, @NotNull List<Flag> flags) {
        this.getRegistryContainer().getFlagRegistry().register(key, flags);
    }

    public final <C extends MessageContext> void registerMessage(@NotNull ContextualKey<C> key, @NotNull MessageResolver<S, C> resolver) {
        this.getRegistryContainer().getMessageRegistry().register(key, resolver);
    }

    public final void registerRequirement(@NotNull RequirementKey key, @NotNull RequirementResolver<D, S> resolver) {
        this.getRegistryContainer().getRequirementRegistry().register(key, resolver);
    }

    @NotNull
    protected abstract RegistryContainer<D, S> getRegistryContainer();

    @NotNull
    protected O getCommandOptions() {
        return this.commandOptions;
    }
}

