/*
 * Decompiled with CFR 0.152.
 */
package libs.dev.triumphteam.cmd.bukkit;

import libs.dev.triumphteam.cmd.bukkit.CommandPermission;
import libs.dev.triumphteam.cmd.bukkit.message.BukkitMessageKey;
import libs.dev.triumphteam.cmd.bukkit.message.NoPermissionMessageContext;
import libs.dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import libs.dev.triumphteam.cmd.core.extention.registry.MessageRegistry;
import libs.dev.triumphteam.cmd.core.extention.sender.SenderMapper;
import libs.dev.triumphteam.cmd.core.requirement.Requirement;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

final class PermissionRequirement<S>
implements Requirement<CommandSender, S> {
    private final CommandPermission permission;

    public PermissionRequirement(@NotNull CommandPermission permission) {
        this.permission = permission;
    }

    @Override
    public boolean test(@NotNull S sender, @NotNull CommandMeta meta, @NotNull SenderMapper<CommandSender, S> senderMapper) {
        return this.permission.hasPermission(senderMapper.mapBackwards(sender));
    }

    @Override
    public void onDeny(@NotNull S sender, @NotNull MessageRegistry<S> messageRegistry, @NotNull CommandMeta meta) {
        messageRegistry.sendMessage(BukkitMessageKey.NO_PERMISSION, sender, new NoPermissionMessageContext(meta, this.permission));
    }

    public String toString() {
        return "PermissionRequirement{permission=" + this.permission + '}';
    }
}

