/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.vital.paper.util.scheduler;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FoliaRunnable
implements Runnable {
    @Nullable
    private GlobalRegionScheduler globalRegionScheduler;
    @Nullable
    private EntityScheduler entityScheduler;
    @Nullable
    private RegionScheduler regionScheduler;
    @Nullable
    private AsyncScheduler asyncScheduler;
    @Nullable
    private Runnable entityRetired;
    @Nullable
    private TimeUnit timeUnit;
    private ScheduledTask task;
    private World world;
    private int chunkX;
    private int chunkZ;

    public FoliaRunnable(@NotNull AsyncScheduler scheduler, @Nullable TimeUnit timeUnit) {
        this.asyncScheduler = scheduler;
        this.timeUnit = timeUnit;
    }

    public FoliaRunnable(@NotNull EntityScheduler scheduler, @Nullable Runnable retired) {
        this.entityScheduler = scheduler;
        this.entityRetired = retired;
    }

    public FoliaRunnable(@NotNull GlobalRegionScheduler scheduler) {
        this.globalRegionScheduler = scheduler;
    }

    public FoliaRunnable(@NotNull RegionScheduler scheduler, @NotNull Location location) {
        this(scheduler, location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public FoliaRunnable(@NotNull RegionScheduler scheduler, @NotNull World world, int chunkX, int chunkZ) {
        this.regionScheduler = scheduler;
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public final boolean isCancelled() throws IllegalStateException {
        this.checkScheduled();
        return this.task.isCancelled();
    }

    public void cancel() throws IllegalStateException {
        this.cancel(null);
    }

    @Override
    public void run() {
    }

    public void cancel(@Nullable Consumer<FoliaRunnable> consumer) throws IllegalStateException {
        this.task.cancel();
        if (consumer != null) {
            consumer.accept(this);
        }
    }

    public final boolean execute(@NotNull JavaPlugin plugin) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        if (this.globalRegionScheduler != null) {
            this.globalRegionScheduler.execute((Plugin)plugin, (Runnable)this);
        } else {
            if (this.entityScheduler != null) {
                return this.entityScheduler.execute((Plugin)plugin, (Runnable)this, this.entityRetired, 1L);
            }
            if (this.regionScheduler != null) {
                this.regionScheduler.execute((Plugin)plugin, this.world, this.chunkX, this.chunkZ, (Runnable)this);
            } else if (this.asyncScheduler != null) {
                this.asyncScheduler.runNow((Plugin)plugin, scheduledTask -> this.run());
            } else {
                throw new UnsupportedOperationException("The task type is not supported.");
            }
        }
        return true;
    }

    @NotNull
    public final ScheduledTask run(@NotNull JavaPlugin plugin) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        if (this.globalRegionScheduler != null) {
            return this.setupTask(this.globalRegionScheduler.run((Plugin)plugin, scheduledTask -> this.run()));
        }
        if (this.entityScheduler != null) {
            return this.setupTask(this.entityScheduler.run((Plugin)plugin, scheduledTask -> this.run(), this.entityRetired));
        }
        if (this.regionScheduler != null) {
            return this.setupTask(this.regionScheduler.run((Plugin)plugin, this.world, this.chunkX, this.chunkZ, scheduledTask -> this.run()));
        }
        if (this.asyncScheduler != null) {
            return this.setupTask(this.asyncScheduler.runDelayed((Plugin)plugin, scheduledTask -> this.run(), 50L, TimeUnit.MILLISECONDS));
        }
        throw new UnsupportedOperationException("The task type is not supported.");
    }

    @NotNull
    public final ScheduledTask runDelayed(@NotNull JavaPlugin plugin, long delay) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        delay = Math.max(1L, delay);
        if (this.globalRegionScheduler != null) {
            return this.setupTask(this.globalRegionScheduler.runDelayed((Plugin)plugin, scheduledTask -> this.run(), delay));
        }
        if (this.entityScheduler != null) {
            return this.setupTask(this.entityScheduler.runDelayed((Plugin)plugin, scheduledTask -> this.run(), this.entityRetired, delay));
        }
        if (this.regionScheduler != null) {
            return this.setupTask(this.regionScheduler.runDelayed((Plugin)plugin, this.world, this.chunkX, this.chunkZ, scheduledTask -> this.run(), delay));
        }
        if (this.asyncScheduler != null && this.timeUnit != null) {
            return this.setupTask(this.asyncScheduler.runDelayed((Plugin)plugin, scheduledTask -> this.run(), delay, this.timeUnit));
        }
        throw new UnsupportedOperationException("The task type is not supported.");
    }

    @NotNull
    public final ScheduledTask runAtFixedRate(@NotNull JavaPlugin plugin, long delay, long period) throws IllegalArgumentException, IllegalStateException {
        this.checkNotYetScheduled();
        delay = Math.max(1L, delay);
        period = Math.max(1L, period);
        if (this.globalRegionScheduler != null) {
            return this.setupTask(this.globalRegionScheduler.runAtFixedRate((Plugin)plugin, scheduledTask -> this.run(), delay, period));
        }
        if (this.entityScheduler != null) {
            return this.setupTask(this.entityScheduler.runAtFixedRate((Plugin)plugin, scheduledTask -> this.run(), this.entityRetired, delay, period));
        }
        if (this.regionScheduler != null) {
            return this.setupTask(this.regionScheduler.runAtFixedRate((Plugin)plugin, this.world, this.chunkX, this.chunkZ, scheduledTask -> this.run(), delay, period));
        }
        if (this.asyncScheduler != null && this.timeUnit != null) {
            return this.setupTask(this.asyncScheduler.runAtFixedRate((Plugin)plugin, scheduledTask -> this.run(), delay, period, this.timeUnit));
        }
        throw new UnsupportedOperationException("The task type is not supported.");
    }

    public final int getTaskId() throws IllegalStateException {
        this.checkScheduled();
        return this.task.hashCode();
    }

    private void checkScheduled() {
        if (this.task == null) {
            throw new IllegalStateException("Not scheduled yet");
        }
    }

    private void checkNotYetScheduled() {
        if (this.task != null) {
            throw new IllegalStateException("Already scheduled as " + this.task.hashCode());
        }
    }

    @NotNull
    private ScheduledTask setupTask(@NotNull ScheduledTask task) {
        this.task = task;
        return this.task;
    }
}

