/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.vital.paper.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import libs.com.ryderbelserion.vital.paper.api.enums.Support;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvUtil {
    private AdvUtil() {
        throw new AssertionError();
    }

    @NotNull
    public static Component parse(@NotNull String value, @Nullable UUID uuid) {
        if (value.isEmpty()) {
            return Component.empty();
        }
        return uuid != null ? AdvUtil.parse(value, null, Bukkit.getPlayer((UUID)uuid)) : AdvUtil.parse(value, null, null);
    }

    @NotNull
    public static Component parse(@NotNull String value, @Nullable Map<String, String> placeholders, @Nullable Player player) {
        if (value.isEmpty()) {
            return Component.empty();
        }
        return AdvUtil.parse(AdvUtil.parsePlaceholders(value, placeholders, player));
    }

    public static String parsePlaceholders(@NotNull String value, @Nullable Map<String, String> placeholders, @Nullable Player player) {
        String clonedMessage;
        String string = clonedMessage = Support.placeholder_api.isEnabled() && player != null ? PlaceholderAPI.setPlaceholders((Player)player, (String)value) : value;
        if (placeholders != null && !placeholders.isEmpty()) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                String key = entry.getKey().toLowerCase();
                String entryValue = entry.getValue();
                clonedMessage = clonedMessage.replace(key, entryValue);
            }
        }
        return clonedMessage;
    }

    @NotNull
    public static Component parse(@NotNull String message) {
        if (message.isEmpty()) {
            return Component.empty();
        }
        return MiniMessage.miniMessage().deserialize((Object)message).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    @NotNull
    public static Component toComponent(@NotNull String component) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(component.replace("\u00a7", "&"));
    }

    @NotNull
    public static List<Component> toComponent(final @NotNull List<String> lore) {
        return new ArrayList<Component>(lore.size()){
            {
                super(arg0);
                lore.forEach((? super T line) -> this.add(AdvUtil.toComponent(line)));
            }
        };
    }

    @NotNull
    public static List<String> fromComponent(@NotNull List<Component> lore) {
        return AdvUtil.fromComponent(lore, false);
    }

    @NotNull
    public static List<String> fromComponent(final @NotNull List<Component> lore, final boolean isMessage) {
        return new ArrayList<String>(lore.size()){
            {
                super(arg0);
                lore.forEach((? super T line) -> this.add(AdvUtil.fromComponent(line, isMessage)));
            }
        };
    }

    @NotNull
    public static String fromComponent(@NotNull Component component) {
        return AdvUtil.fromComponent(component, false);
    }

    @NotNull
    public static String fromComponent(@NotNull Component component, boolean isMessage) {
        String value = (String)MiniMessage.miniMessage().serialize(component);
        if (isMessage) {
            return value.replace("\\<", "<");
        }
        return value;
    }

    @NotNull
    public static String convert(@NotNull String component) {
        return AdvUtil.convert(component, false);
    }

    @NotNull
    public static List<String> convert(@NotNull List<String> components) {
        return AdvUtil.convert(components, false);
    }

    @NotNull
    public static List<String> convert(final @NotNull List<String> components, final boolean isMessage) {
        return new ArrayList<String>(components.size()){
            {
                super(arg0);
                components.forEach((? super T line) -> this.add(AdvUtil.convert(line, isMessage)));
            }
        };
    }

    @NotNull
    public static String convert(@NotNull String component, boolean isMessage) {
        return AdvUtil.fromComponent(AdvUtil.toComponent(component), isMessage);
    }
}

