/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.vital.paper.api.files;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import libs.com.ryderbelserion.vital.common.VitalAPI;
import libs.com.ryderbelserion.vital.common.api.Provider;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class CustomFile {
    private final VitalAPI api = Provider.getApi();
    private final ComponentLogger logger = this.api.getComponentLogger();
    private final boolean isVerbose = this.api.isVerbose();
    private final String cleanName;
    private final File file;
    private YamlConfiguration configuration;

    public CustomFile(String name, File file) {
        this.cleanName = name.replace(".yml", "");
        this.file = file;
    }

    public final CustomFile load() {
        block4: {
            if (this.file.isDirectory()) {
                if (this.isVerbose) {
                    this.logger.warn("Cannot load, as it is a directory.");
                }
                return this;
            }
            try {
                this.configuration = CompletableFuture.supplyAsync(() -> YamlConfiguration.loadConfiguration((File)this.file)).join();
            }
            catch (Exception exception) {
                if (!this.isVerbose) break block4;
                this.logger.error("Failed to load {}", (Object)this.file.getName(), (Object)exception);
            }
        }
        return this;
    }

    public final CustomFile save() {
        if (this.file.isDirectory()) {
            if (this.isVerbose) {
                this.logger.warn("Cannot save, as it is a directory.");
            }
            return this;
        }
        if (this.configuration == null) {
            if (this.isVerbose) {
                this.logger.error("File configuration is null, cannot save!");
            }
            return this;
        }
        CompletableFuture.runAsync(() -> {
            block2: {
                try {
                    this.configuration.save(this.file);
                }
                catch (Exception exception) {
                    if (!this.isVerbose) break block2;
                    this.logger.error("Failed to save: {}...", (Object)this.file.getName(), (Object)exception);
                }
            }
        });
        return this;
    }

    @Nullable
    public final YamlConfiguration getConfiguration() {
        return this.configuration;
    }

    public final boolean exists() {
        return this.getConfiguration() != null;
    }

    public final String getCleanName() {
        return this.cleanName;
    }

    public final File getFile() {
        return this.file;
    }
}

