/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.vital.paper.api.builders;

import libs.com.ryderbelserion.vital.paper.util.AdvUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentBuilder {
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TextComponent.Builder builder = Component.text();
    private final Player target;
    private String value;

    public ComponentBuilder(@NotNull Player target) {
        this.target = target;
    }

    @NotNull
    public final ComponentBuilder append(@NotNull Component component) {
        this.builder.append(component);
        return this;
    }

    @NotNull
    public final ComponentBuilder applyHover(@NotNull String text) {
        if (text.isEmpty()) {
            return this;
        }
        this.builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)AdvUtil.parse(text)));
        return this;
    }

    @NotNull
    public final ComponentBuilder applyClick(@Nullable ClickEvent.Action action, @NotNull String text) {
        if (action == null || text.isEmpty()) {
            return this;
        }
        this.builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)action, (String)text));
        return this;
    }

    @NotNull
    public final TextComponent getComponent() {
        if (this.value.isEmpty()) {
            return Component.empty();
        }
        Component message = AdvUtil.parse(this.value);
        return (TextComponent)((TextComponent.Builder)this.builder.append(message)).build();
    }

    public void send() {
        if (this.getComponent().equals((Object)Component.empty())) {
            return;
        }
        this.target.sendMessage((Component)this.getComponent());
    }

    @NotNull
    public final Player getTarget() {
        return this.target;
    }

    public void applyValue(@NotNull String value) {
        if (value.isEmpty()) {
            return;
        }
        this.value = value;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }
}

