/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.vital.paper;

import java.io.File;
import libs.com.ryderbelserion.vital.common.VitalAPI;
import libs.com.ryderbelserion.vital.paper.api.files.FileManager;
import libs.com.ryderbelserion.vital.paper.modules.EventRegistry;
import libs.com.ryderbelserion.vital.paper.modules.ModuleLoader;
import libs.com.ryderbelserion.vital.paper.util.scheduler.PaperScheduler;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Vital
implements VitalAPI {
    private PaperScheduler scheduler;
    private FileManager fileManager;
    private ModuleLoader loader;
    private final JavaPlugin plugin;

    public Vital(JavaPlugin plugin) {
        this.plugin = plugin;
        this.start();
    }

    @Override
    public void start() {
        VitalAPI.super.start();
        this.loader = new ModuleLoader(new EventRegistry(this.plugin));
        this.scheduler = new PaperScheduler(this.plugin);
        this.fileManager = new FileManager();
        this.getDirectory().mkdirs();
    }

    @Override
    public final File getDirectory() {
        return this.plugin.getDataFolder();
    }

    public final FileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public final File getModsDirectory() {
        return this.plugin.getServer().getPluginsFolder();
    }

    @Override
    public void saveResource(@NotNull String fileName, boolean replace) {
        this.plugin.saveResource(fileName, replace);
    }

    @Override
    @NotNull
    public final ComponentLogger getComponentLogger() {
        return this.plugin.getComponentLogger();
    }

    @Override
    public final PaperScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public final String getPluginName() {
        return this.plugin.getName();
    }

    public final ModuleLoader getLoader() {
        return this.loader;
    }
}

