/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.vital.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import libs.com.ryderbelserion.vital.common.VitalAPI;
import libs.com.ryderbelserion.vital.common.api.Provider;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    @NotNull
    private static final VitalAPI api = Provider.getApi();
    @NotNull
    private static final ComponentLogger logger = api.getComponentLogger();
    @NotNull
    private static final File dataFolder = api.getDirectory();

    private FileUtil() {
        throw new AssertionError();
    }

    public static void download(String link, File directory) {
        CompletableFuture.runAsync(() -> {
            URL url = null;
            try {
                url = URI.create(link).toURL();
            }
            catch (MalformedURLException exception) {
                exception.printStackTrace();
            }
            if (url == null) {
                return;
            }
            try (ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
                 FileOutputStream outputStream = new FileOutputStream(directory);){
                outputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        });
    }

    public static void write(File file, String format) {
        try (FileWriter writer = new FileWriter(file, true);
             BufferedWriter bufferedWriter = new BufferedWriter(writer);){
            bufferedWriter.write(format);
            bufferedWriter.newLine();
            writer.flush();
        }
        catch (Exception exception) {
            logger.warn("Failed to write to: {}", (Object)file.getName(), (Object)exception);
        }
    }

    public static void zip(File file, boolean purge) {
        FileUtil.zip(List.of(file), null, "", purge);
    }

    public static void zip(File file, String extension, boolean purge) {
        List<File> files = FileUtil.getFileObjects(dataFolder, file.getName(), extension);
        if (files.isEmpty()) {
            return;
        }
        boolean hasNonEmptyFile = false;
        for (File zip : files) {
            if (!zip.exists() || zip.length() <= 0L) continue;
            hasNonEmptyFile = true;
            break;
        }
        if (!hasNonEmptyFile) {
            if (api.isVerbose()) {
                logger.warn("All log files are empty. No zip file will be created.");
            }
            return;
        }
        int count = FileUtil.getFiles(file, ".gz", true).size();
        FileUtil.zip(files, file, "-" + ++count, purge);
    }

    public static void zip(List<File> files, @Nullable File directory, String extra, boolean purge) {
        if (files.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        if (!builder.isEmpty()) {
            builder.append(extra);
        }
        builder.append(".gz");
        if (directory != null) {
            directory.mkdirs();
        }
        File zipFile = new File(directory == null ? dataFolder : directory, builder.toString());
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
             ZipOutputStream zipOut = new ZipOutputStream(fileOutputStream);){
            for (File file : files) {
                if (file.length() > 0L) {
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        int length;
                        ZipEntry zipEntry = new ZipEntry(file.getName());
                        zipOut.putNextEntry(zipEntry);
                        byte[] bytes = new byte[1024];
                        while ((length = fileInputStream.read(bytes)) >= 0) {
                            zipOut.write(bytes, 0, length);
                        }
                    }
                    if (!purge) continue;
                    file.delete();
                    continue;
                }
                if (!api.isVerbose()) continue;
                logger.warn("The file named {}'s size is 0, We are not adding to zip.", (Object)file.getName());
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static void extract(@NotNull String fileName, boolean overwrite) {
        api.saveResource(fileName, overwrite);
    }

    public static void visit(Consumer<Path> consumer, String input) throws IOException {
        URL resource = FileUtil.class.getClassLoader().getResource("config.yml");
        if (resource == null) {
            throw new IllegalStateException("We are lacking awareness of the files in src/main/resources/" + input);
        }
        URI path = URI.create(resource.toString().split("!")[0] + "!/");
        try (FileSystem fileSystem = FileSystems.newFileSystem(path, Map.of("create", "true"));){
            Path toVisit = fileSystem.getPath(input, new String[0]);
            if (Files.exists(toVisit, new LinkOption[0])) {
                consumer.accept(toVisit);
            }
        }
    }

    public static void extract(String input) {
        FileUtil.extract(input, input, false);
    }

    public static void extract(String input, String output, boolean replaceExisting) {
        try {
            FileUtil.visit(path -> {
                block9: {
                    Path directory = api.getDirectory().toPath().resolve(output);
                    try {
                        if (replaceExisting) {
                            directory.toFile().delete();
                        }
                        if (Files.exists(directory, new LinkOption[0])) break block9;
                        directory.toFile().mkdirs();
                        try (Stream<Path> files = Files.walk(path, new FileVisitOption[0]);){
                            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                                block8: {
                                    try {
                                        Path langFile = directory.resolve(file.getFileName().toString());
                                        if (Files.exists(langFile, new LinkOption[0])) break block8;
                                        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                                            Files.copy(stream, langFile, new CopyOption[0]);
                                        }
                                    }
                                    catch (IOException exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                }
            }, input);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static void extracts(@Nullable Class<?> object, @NotNull String sourceDir, @Nullable Path outDir, boolean replaceExisting) {
        if (object == null || outDir == null || sourceDir.isEmpty()) {
            return;
        }
        try (JarFile jarFile = new JarFile(Path.of(object.getProtectionDomain().getCodeSource().getLocation().toURI()).toFile());){
            String path = sourceDir.substring(1);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path)) continue;
                Path file = outDir.resolve(name.substring(path.length()));
                boolean exists = Files.exists(file, new LinkOption[0]);
                if (!replaceExisting && exists) continue;
                if (entry.isDirectory()) {
                    if (exists) continue;
                    try {
                        Files.createDirectories(file, new FileAttribute[0]);
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                try (BufferedInputStream inputStream = new BufferedInputStream(jarFile.getInputStream(entry));
                     BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file.toFile()));){
                    int readCount;
                    byte[] buffer = new byte[4096];
                    while ((readCount = ((InputStream)inputStream).read(buffer)) > 0) {
                        ((OutputStream)outputStream).write(buffer, 0, readCount);
                    }
                    ((OutputStream)outputStream).flush();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static List<String> getFiles(@NotNull File dir, @NotNull String extension, boolean keepExtension) {
        ArrayList<Object> files = new ArrayList<Object>();
        String[] file = dir.list();
        if (file != null) {
            File[] filesList = dir.listFiles();
            if (filesList != null) {
                for (File directory : filesList) {
                    String[] folder;
                    if (!directory.isDirectory() || (folder = directory.list()) == null) continue;
                    for (String name : folder) {
                        if (!name.endsWith(extension)) continue;
                        files.add(keepExtension ? name : name.replaceAll(extension, ""));
                    }
                }
            }
            for (String name : file) {
                if (!name.endsWith(extension)) continue;
                files.add(keepExtension ? name : name.replaceAll(extension, ""));
            }
        }
        return Collections.unmodifiableList(files);
    }

    public static List<String> getFiles(@NotNull File directory, @NotNull String folder, @NotNull String extension) {
        return FileUtil.getFiles(folder.isEmpty() ? directory : new File(directory, folder), extension, false);
    }

    public static List<File> getFileObjects(@NotNull File directory, @NotNull String folder, @NotNull String extension) {
        ArrayList<File> files = new ArrayList<File>();
        File root = new File(directory, folder);
        FileUtil.getFiles(folder.isEmpty() ? directory : root, extension, true).forEach(file -> files.add(new File(root, (String)file)));
        return files;
    }
}

