/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.vital.common.api.managers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import libs.com.ryderbelserion.vital.common.VitalAPI;
import libs.com.ryderbelserion.vital.common.api.Provider;
import libs.com.ryderbelserion.vital.common.api.interfaces.IPlugin;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManager {
    private static final VitalAPI api = Provider.getApi();
    private static final ComponentLogger logger = api.getComponentLogger();
    private static final boolean isVerbose = api.isVerbose();
    private static final Map<String, IPlugin> plugins = new HashMap<String, IPlugin>();

    public static void registerPlugin(@NotNull IPlugin plugin) {
        plugins.put(plugin.getName(), plugin);
        plugin.init();
    }

    @Nullable
    public static IPlugin getPlugin(@NotNull String name) {
        return plugins.get(name);
    }

    public static boolean isEnabled(@NotNull String name) {
        IPlugin plugin = PluginManager.getPlugin(name);
        if (plugin == null) {
            return false;
        }
        return plugin.isEnabled();
    }

    public static void unregisterPlugin(@NotNull IPlugin plugin) {
        plugins.remove(plugin.getName());
        plugin.stop();
    }

    public static void printPlugins() {
        if (isVerbose) {
            PluginManager.getPlugins().forEach((name, plugin) -> {
                if (plugin.isEnabled() && !name.isEmpty()) {
                    logger.info("{}: FOUND", name);
                    return;
                }
                logger.info("{}: NOT FOUND", name);
            });
        }
    }

    @NotNull
    public static Map<String, IPlugin> getPlugins() {
        return Collections.unmodifiableMap(plugins);
    }
}

