/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.utils;

import com.badbones69.crazycrates.CrazyCrates;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.enums.Permissions;
import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.common.utils.Methods;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import libs.com.ryderbelserion.vital.common.utils.FileUtil;
import libs.com.ryderbelserion.vital.paper.api.enums.Support;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiscUtils {
    private static final CrazyCrates plugin = CrazyCrates.getPlugin();

    public static void sendCommand(@Nullable CommandSender sender, @NotNull String command, @NotNull Map<String, String> placeholders) {
        if (command.isEmpty()) {
            return;
        }
        final Server server = plugin.getServer();
        final String result = MiscUtils.populatePlaceholders(sender, command, placeholders);
        new FoliaRunnable(server.getGlobalRegionScheduler()){

            @Override
            public void run() {
                server.dispatchCommand((CommandSender)server.getConsoleSender(), result);
            }
        }.run(plugin);
    }

    public static void sendCommand(@NotNull String command, @NotNull Map<String, String> placeholders) {
        MiscUtils.sendCommand(null, command, placeholders);
    }

    public static void sendCommand(@NotNull String command) {
        MiscUtils.sendCommand(command, new HashMap<String, String>());
    }

    public static String populatePlaceholders(@Nullable CommandSender sender, @NotNull String line, @NotNull Map<String, String> placeholders) {
        if (sender != null && Support.placeholder_api.isEnabled() && sender instanceof Player) {
            Player player = (Player)sender;
            line = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
        }
        if (!placeholders.isEmpty()) {
            for (Map.Entry<String, String> placeholder : placeholders.entrySet()) {
                if (placeholder == null) continue;
                String key = placeholder.getKey();
                String value = placeholder.getValue();
                if (key == null || value == null) continue;
                line = line.replace(key, value).replace(key.toLowerCase(), value);
            }
        }
        return line;
    }

    public static void janitor() {
        File logsFolder = new File(plugin.getDataFolder(), "logs");
        if (logsFolder.exists() && ConfigManager.getConfig().getProperty(ConfigKeys.log_to_file).booleanValue()) {
            File crateLog = Files.crate_log.getFile();
            File keyLog = Files.key_log.getFile();
            FileUtil.zip(logsFolder, ".log", true);
            try {
                if (!crateLog.exists()) {
                    crateLog.createNewFile();
                }
                if (!keyLog.exists()) {
                    keyLog.createNewFile();
                }
            }
            catch (IOException exception) {
                plugin.getComponentLogger().warn("Failed to create files.");
            }
        }
    }

    public static double calculateWeight(int chance, int maxRange) {
        return new BigDecimal((double)chance / (double)maxRange * 100.0).setScale(1, RoundingMode.HALF_UP).doubleValue();
    }

    public static void spawnFirework(@NotNull Location location, @Nullable Color color) {
        Firework firework = (Firework)location.getWorld().spawnEntity(location, EntityType.FIREWORK_ROCKET);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull FireworkEffect.Builder effect = FireworkEffect.builder().with(FireworkEffect.Type.BALL).trail(false).flicker(false);
        if (color != null) {
            effect.withColor(color);
        } else {
            effect.withColor(Color.RED).withColor(Color.AQUA).withColor(Color.ORANGE).withColor(Color.YELLOW);
        }
        fireworkMeta.addEffects(new FireworkEffect[]{effect.build()});
        fireworkMeta.setPower(0);
        firework.setFireworkMeta(fireworkMeta);
        PersistentDataContainer fireworkData = firework.getPersistentDataContainer();
        fireworkData.set(Keys.no_firework_damage.getNamespacedKey(), PersistentDataType.BOOLEAN, (Object)true);
        plugin.getServer().getRegionScheduler().runDelayed((Plugin)plugin, location, scheduledTask -> firework.detonate(), 3L);
    }

    @NotNull
    public static String location(@NotNull Location location, boolean getName) {
        String name = getName ? location.getWorld().getName() : String.valueOf(location.getWorld().getUID());
        return name + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    @NotNull
    public static String location(@NotNull Location location) {
        return MiscUtils.location(location, false);
    }

    public static boolean isInventoryFull(@NotNull Player player) {
        return player.getInventory().firstEmpty() == -1;
    }

    public static void save() {
        YamlConfiguration data = Files.data.getConfiguration();
        YamlConfiguration location = Files.locations.getConfiguration();
        boolean isSave = false;
        if (!location.contains("Locations")) {
            location.set("Locations.Clear", null);
            isSave = true;
        }
        if (!data.contains("Players")) {
            data.set("Players.Clear", null);
            isSave = true;
        }
        if (!data.contains("Prizes")) {
            data.set("Prizes.Clear", null);
            isSave = true;
        }
        if (isSave) {
            Files.data.save();
        }
    }

    @Nullable
    public static Map<Integer, ItemStack> removeMultipleItemStacks(@NotNull Inventory inventory, ItemStack ... items) {
        if (items != null) {
            HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
            block0: for (int i = 0; i < items.length; ++i) {
                ItemStack item = items[i];
                int toDelete = item.getAmount();
                do {
                    ItemStack[] toSearch;
                    int first;
                    if ((first = MiscUtils.getFirstItem(item, false, toSearch = inventory.getContents())) == -1) {
                        item.setAmount(toDelete);
                        leftover.put(i, item);
                        continue block0;
                    }
                    ItemStack itemStack = inventory.getItem(first);
                    if (itemStack == null) continue;
                    int amount = itemStack.getAmount();
                    if (amount <= toDelete) {
                        toDelete -= amount;
                        inventory.clear(first);
                        continue;
                    }
                    itemStack.setAmount(amount - toDelete);
                    inventory.setItem(first, itemStack);
                    toDelete = 0;
                } while (toDelete > 0);
            }
            return leftover;
        }
        if (MiscUtils.isLogging()) {
            plugin.getComponentLogger().warn("Items cannot be null.");
        }
        return null;
    }

    private static int getFirstItem(@Nullable ItemStack item, boolean getAmount, @Nullable ItemStack[] inventory) {
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack inventoryItem = inventory[i];
            if (inventoryItem == null || (!getAmount || !item.equals((Object)inventoryItem)) && (getAmount || !item.isSimilar(inventoryItem))) continue;
            return i;
        }
        return -1;
    }

    public static void failedToTakeKey(@NotNull CommandSender player, @NotNull String crateName) {
        if (MiscUtils.isLogging()) {
            List.of("An error has occurred while trying to take a key from a player.", "Player: " + player.getName(), "Key: " + crateName).forEach(arg_0 -> ((ComponentLogger)plugin.getComponentLogger()).warn(arg_0));
            List.of("<red>An issue has occurred when trying to take a key.", "<red>A list of potential reasons", "", " <yellow>-> <light_purple>Not enough keys.", " <yellow>-> <light_purple>Key is in off hand.").forEach(line -> player.sendRichMessage(Methods.getPrefix(line)));
        }
    }

    public static long pickNumber(long min, long max) {
        ++max;
        try {
            return min + ThreadLocalRandom.current().nextLong(max - min);
        }
        catch (IllegalArgumentException exception) {
            return min;
        }
    }

    public static int randomNumber(int min, int max) {
        return MiscUtils.useOtherRandom() ? min + ThreadLocalRandom.current().nextInt(max - min) : min + new Random().nextInt(max - min);
    }

    public static ItemBuilder getRandomPaneColor() {
        List<Material> panes = Arrays.asList(Material.LIGHT_BLUE_STAINED_GLASS_PANE, Material.MAGENTA_STAINED_GLASS_PANE, Material.YELLOW_STAINED_GLASS_PANE, Material.PURPLE_STAINED_GLASS_PANE, Material.ORANGE_STAINED_GLASS_PANE, Material.GREEN_STAINED_GLASS_PANE, Material.BROWN_STAINED_GLASS_PANE, Material.BLACK_STAINED_GLASS_PANE, Material.BLUE_STAINED_GLASS_PANE, Material.CYAN_STAINED_GLASS_PANE, Material.GRAY_STAINED_GLASS_PANE, Material.LIME_STAINED_GLASS_PANE, Material.PINK_STAINED_GLASS_PANE, Material.RED_STAINED_GLASS_PANE);
        return new ItemBuilder(panes.get(ThreadLocalRandom.current().nextInt(panes.size())));
    }

    public static void addItem(Player player, ItemStack ... items) {
        PlayerInventory inventory = player.getInventory();
        inventory.setMaxStackSize(64);
        inventory.addItem(items);
    }

    public static List<Integer> slowSpin(int full, int cut) {
        ArrayList<Integer> slow = new ArrayList<Integer>();
        int index = full;
        while (cut > 0) {
            if (full <= index - cut || full >= index - cut) {
                slow.add(index);
                index -= cut;
                --cut;
            }
            --full;
        }
        return slow;
    }

    public static boolean useOtherRandom() {
        return ConfigManager.getConfig().getProperty(ConfigKeys.use_different_random);
    }

    public static void registerPermission(String permission, String description, boolean isDefault) {
        if (permission.isEmpty()) {
            return;
        }
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        if (pluginManager.getPermission(permission) != null) {
            if (MiscUtils.isLogging()) {
                plugin.getComponentLogger().warn("Permission {} is already on the server. Pick a different name", (Object)permission);
            }
            return;
        }
        if (MiscUtils.isLogging()) {
            plugin.getComponentLogger().warn("Permission {} is registered", (Object)permission);
        }
        pluginManager.addPermission(new Permission(permission, description, isDefault ? PermissionDefault.TRUE : PermissionDefault.OP));
    }

    public static void unregisterPermission(String permission) {
        if (permission.isEmpty()) {
            return;
        }
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        if (pluginManager.getPermission(permission) == null) {
            if (MiscUtils.isLogging()) {
                plugin.getComponentLogger().warn("Permission {} is not registered", (Object)permission);
            }
            return;
        }
        if (MiscUtils.isLogging()) {
            plugin.getComponentLogger().warn("Permission {} is unregistered", (Object)permission);
        }
        pluginManager.removePermission(permission);
    }

    public static void registerPermissions() {
        Arrays.stream(Permissions.values()).toList().forEach(permission -> {
            Permission newPermission = new Permission(permission.getPermission(), permission.getDescription(), permission.isDefault(), permission.getChildren());
            plugin.getServer().getPluginManager().addPermission(newPermission);
        });
    }

    public static boolean isLogging() {
        return plugin.getVital().isVerbose();
    }

    public static boolean isExcellentCratesEnabled() {
        return plugin.getServer().getPluginManager().isPluginEnabled("ExcellentCrates");
    }
}

