/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.menus;

import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.builders.gui.StaticInventoryBuilder;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Tier;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.List;
import java.util.UUID;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.Gui;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.GuiFiller;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.GuiItem;
import net.kyori.adventure.sound.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CrateTierMenu
extends StaticInventoryBuilder {
    private final Player player = this.getPlayer();
    private final Crate crate = this.getCrate();
    private final Gui gui = this.getGui();

    public CrateTierMenu(Player player, Crate crate) {
        super(player, crate);
    }

    @Override
    public void open() {
        if (this.crate == null) {
            return;
        }
        CrateType crateType = this.crate.getCrateType();
        if (crateType != CrateType.casino && crateType != CrateType.cosmic) {
            return;
        }
        boolean isPreviewBorderEnabled = this.crate.isPreviewTierBorderToggle();
        if (isPreviewBorderEnabled) {
            GuiItem guiItem = ((ItemBuilder)this.crate.getPreviewTierBorderItem().setPlayer(this.player)).asGuiItem();
            GuiFiller guiFiller = this.gui.getFiller();
            guiFiller.fillTop(guiItem);
            guiFiller.fillBottom(guiItem);
        }
        UUID uuid = this.player.getUniqueId();
        List<Tier> tiers = this.crate.getTiers();
        tiers.forEach(tier -> {
            ItemStack item = tier.getTierItem(this.player, this.crate);
            int slot = tier.getSlot();
            this.gui.setItem(slot, new GuiItem(item, action -> {
                ItemStack itemStack = action.getCurrentItem();
                if (itemStack == null || itemStack.getType().isAir()) {
                    return;
                }
                PersistentDataContainerView tags = itemStack.getPersistentDataContainer();
                if (tags.has(Keys.crate_tier.getNamespacedKey())) {
                    this.crate.playSound(this.player, this.player.getLocation(), "click-sound", "ui.button.click", Sound.Source.PLAYER);
                    this.crate.getPreview(this.player, (Tier)tier).open();
                }
            }));
        });
        this.addMenuButton(this.player, this.crate, this.gui, this.gui.getRows(), 5);
        this.gui.setOpenGuiAction(event -> this.inventoryManager.addPreviewViewer(uuid));
        this.gui.setCloseGuiAction(event -> this.inventoryManager.removePreviewViewer(uuid));
        this.gui.open(this.player);
    }
}

