/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.menus;

import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.builders.gui.StaticInventoryBuilder;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.utils.ItemUtils;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.text.NumberFormat;
import java.util.UUID;
import libs.com.ryderbelserion.vital.common.utils.StringUtil;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.Gui;
import libs.com.ryderbelserion.vital.paper.api.builders.gui.interfaces.GuiFiller;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryCloseEvent;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateMainMenu
extends StaticInventoryBuilder {
    private final Player player = this.getPlayer();
    private final Gui gui = this.getGui();

    public CrateMainMenu(Player player, String title, int rows) {
        super(player, title, rows);
    }

    @Override
    public void open() {
        UUID uuid = this.player.getUniqueId();
        if (this.config.getProperty(ConfigKeys.filler_toggle).booleanValue()) {
            GuiFiller guiFiller = this.gui.getFiller();
            guiFiller.fill(((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(this.config.getProperty(ConfigKeys.filler_item))).setDisplayName(this.config.getProperty(ConfigKeys.filler_name))).setDisplayLore(this.config.getProperty(ConfigKeys.filler_lore))).setCustomModelData(this.config.getProperty(ConfigKeys.filler_model_data))).asGuiItem());
        }
        if (this.config.getProperty(ConfigKeys.gui_customizer_toggle).booleanValue()) {
            for (String custom : this.config.getProperty(ConfigKeys.gui_customizer)) {
                ItemBuilder item = new ItemBuilder();
                int slot = 0;
                block23: for (String key : custom.split(", ")) {
                    String option = key.split(":")[0];
                    String value = key.replace(option + ":", "").replace(option, "");
                    switch (option.toLowerCase()) {
                        case "item": {
                            item.withType(value.toLowerCase());
                            continue block23;
                        }
                        case "name": {
                            item.setDisplayName(this.getCrates(value).replace("{player}", this.player.getName()));
                            continue block23;
                        }
                        case "lore": {
                            String[] lore;
                            for (String line : lore = value.split(",")) {
                                item.addDisplayLore(this.getCrates(line).replace("{player}", this.player.getName()));
                            }
                            continue block23;
                        }
                        case "custom-model-data": {
                            item.setCustomModelData(StringUtil.tryParseInt(value).orElse(-1).intValue());
                            continue block23;
                        }
                        case "glowing": {
                            item.setGlowing(StringUtil.tryParseBoolean(value).orElse(null));
                            continue block23;
                        }
                        case "slot": {
                            slot = StringUtil.tryParseInt(value).orElse(-1).intValue();
                            continue block23;
                        }
                        case "unbreakable-item": {
                            item.setUnbreakable(StringUtil.tryParseBoolean(value).orElse(false));
                            continue block23;
                        }
                        case "hide-item-flags": {
                            item.setHidingItemFlags(StringUtil.tryParseBoolean(value).orElse(false));
                            continue block23;
                        }
                        case "command": {
                            Server server = this.plugin.getServer();
                            server.dispatchCommand((CommandSender)server.getConsoleSender(), value);
                        }
                    }
                }
                this.gui.setItem(slot, ((ItemBuilder)item.setPlayer(this.player)).asGuiItem());
            }
        }
        for (Crate crate : this.crateManager.getUsableCrates()) {
            YamlConfiguration file = crate.getFile();
            ConfigurationSection section = file.getConfigurationSection("Crate");
            if (section == null || !section.getBoolean("InGUI", false)) continue;
            String fileName = crate.getFileName();
            int slot = section.getInt("Slot");
            ItemBuilder builder = (ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder().withType(section.getString("Item", "chest").toLowerCase())).setDisplayName(crate.getCrateName())).setCustomModelData(section.getInt("Custom-Model-Data", -1))).addLorePlaceholder("%keys%", NumberFormat.getNumberInstance().format(this.userManager.getVirtualKeys(uuid, fileName)))).addLorePlaceholder("%keys_physical%", NumberFormat.getNumberInstance().format(this.userManager.getPhysicalKeys(uuid, fileName)))).addLorePlaceholder("%keys_total%", NumberFormat.getNumberInstance().format(this.userManager.getTotalKeys(uuid, fileName)))).addLorePlaceholder("%crate_opened%", NumberFormat.getNumberInstance().format(this.userManager.getCrateOpened(uuid, fileName)))).addLorePlaceholder("%player%", this.player.getName())).setPersistentString(Keys.crate_key.getNamespacedKey(), fileName);
            this.gui.setItem(slot, ItemUtils.getItem(section, builder, this.player).asGuiItem(event -> {
                String fancyName = crate.getCrateName();
                if (event.getClick() == ClickType.RIGHT) {
                    if (crate.isPreviewEnabled()) {
                        crate.playSound(this.player, this.player.getLocation(), "click-sound", "ui.button.click", Sound.Source.PLAYER);
                        this.gui.close(this.player, InventoryCloseEvent.Reason.OPEN_NEW, false);
                        this.inventoryManager.openNewCratePreview(this.player, crate);
                    } else {
                        Messages.preview_disabled.sendMessage((CommandSender)this.player, "{crate}", fancyName);
                    }
                    return;
                }
                if (this.crateManager.isInOpeningList(this.player)) {
                    Messages.already_opening_crate.sendMessage((CommandSender)this.player, "{crate}", fancyName);
                    return;
                }
                boolean hasKey = false;
                KeyType keyType = KeyType.virtual_key;
                if (this.userManager.getVirtualKeys(uuid, fileName) >= 1) {
                    hasKey = true;
                } else if (this.config.getProperty(ConfigKeys.virtual_accepts_physical_keys).booleanValue() && this.userManager.hasPhysicalKey(uuid, fileName, false)) {
                    hasKey = true;
                    keyType = KeyType.physical_key;
                }
                if (!hasKey) {
                    if (this.config.getProperty(ConfigKeys.need_key_sound_toggle).booleanValue()) {
                        Sound sound = Sound.sound((Key)Key.key((String)this.config.getProperty(ConfigKeys.need_key_sound)), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f);
                        this.player.playSound(sound);
                    }
                    Messages.no_virtual_key.sendMessage((CommandSender)this.player, "{crate}", fancyName);
                    return;
                }
                for (String world : this.config.getProperty(ConfigKeys.disabled_worlds)) {
                    if (!world.equalsIgnoreCase(this.player.getWorld().getName())) continue;
                    Messages.world_disabled.sendMessage((CommandSender)this.player, "{world}", this.player.getWorld().getName());
                    return;
                }
                if (MiscUtils.isInventoryFull(this.player)) {
                    Messages.inventory_not_empty.sendMessage((CommandSender)this.player, "{crate}", fancyName);
                    return;
                }
                this.crateManager.openCrate(this.player, crate, keyType, this.player.getLocation(), true, false, EventType.event_crate_opened);
            }));
        }
        this.gui.open(this.player);
    }
}

