/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.crates.types;

import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.CrateBuilder;
import com.badbones69.crazycrates.api.builders.ItemBuilder;
import com.badbones69.crazycrates.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.api.events.PlayerPrizeEvent;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.managers.BukkitUserManager;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.tasks.crates.CrateManager;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class WonderCrate
extends CrateBuilder {
    private final CrateManager crateManager;
    private final BukkitUserManager userManager;
    private final Inventory inventory;
    private final Player player;
    private final UUID uuid;
    private final Crate crate;

    public WonderCrate(@NotNull Crate crate, @NotNull Player player, int size) {
        super(crate, player, size);
        this.crateManager = this.plugin.getCrateManager();
        this.userManager = this.plugin.getUserManager();
        this.inventory = this.getInventory();
        this.player = this.getPlayer();
        this.uuid = this.player.getUniqueId();
        this.crate = this.getCrate();
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        final String fileName = this.crate.getFileName();
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.getPlayer());
            return;
        }
        final ArrayList<String> slots = new ArrayList<String>();
        for (int index = 0; index < this.getSize(); ++index) {
            Prize prize = this.crate.pickPrize(this.player);
            slots.add(String.valueOf(index));
            this.setItem(index, prize.getDisplayItem(this.player, this.crate));
        }
        this.player.openInventory(this.inventory);
        this.addCrateTask(new FoliaRunnable(this.player.getScheduler(), null){
            int time;
            int full;
            int slot1;
            int slot2;
            final List<Integer> other;
            Prize prize;
            {
                super(arg0, arg1);
                this.time = 0;
                this.full = 0;
                this.slot1 = 0;
                this.slot2 = 44;
                this.other = new ArrayList<Integer>();
                this.prize = null;
            }

            @Override
            public void run() {
                if (this.time >= 2 && this.full <= 65) {
                    slots.remove("" + this.slot1);
                    slots.remove("" + this.slot2);
                    this.other.add(this.slot1);
                    this.other.add(this.slot2);
                    ItemStack material = ((ItemBuilder)new ItemBuilder(Material.BLACK_STAINED_GLASS_PANE).setDisplayName(" ")).asItemStack();
                    WonderCrate.this.setItem(this.slot1, material);
                    WonderCrate.this.setItem(this.slot2, material);
                    for (String slot : slots) {
                        this.prize = WonderCrate.this.crate.pickPrize(WonderCrate.this.player);
                        WonderCrate.this.setItem(Integer.parseInt(slot), this.prize.getDisplayItem(WonderCrate.this.player, WonderCrate.this.crate));
                    }
                    WonderCrate.this.playSound("cycle-sound", Sound.Source.PLAYER, "block.note_block.xylophone");
                    ++this.slot1;
                    --this.slot2;
                }
                if (this.full > 67) {
                    for (int slot : this.other) {
                        WonderCrate.this.setCustomGlassPane(slot);
                    }
                    WonderCrate.this.playSound("cycle-sound", Sound.Source.PLAYER, "block.note_block.xylophone");
                }
                WonderCrate.this.player.openInventory(WonderCrate.this.getInventory());
                if (this.full > 100) {
                    WonderCrate.this.crateManager.endCrate(WonderCrate.this.player);
                    WonderCrate.this.player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                    if (WonderCrate.this.crate.isCyclePrize() && !PrizeManager.isCapped(WonderCrate.this.crate, WonderCrate.this.player)) {
                        new CrateSpinMenu(WonderCrate.this.player, new GuiSettings(WonderCrate.this.crate, this.prize, Files.respin_gui.getConfiguration())).open();
                        WonderCrate.this.crateManager.removePlayerFromOpeningList(WonderCrate.this.player);
                        return;
                    }
                    WonderCrate.this.userManager.removeRespinPrize(WonderCrate.this.uuid, fileName);
                    if (!WonderCrate.this.crate.isCyclePersistRestart()) {
                        WonderCrate.this.userManager.removeRespinCrate(WonderCrate.this.uuid, fileName, WonderCrate.this.userManager.getCrateRespin(WonderCrate.this.uuid, fileName));
                    }
                    PrizeManager.givePrize(WonderCrate.this.player, this.prize, WonderCrate.this.crate);
                    WonderCrate.this.playSound("stop-sound", Sound.Source.PLAYER, "entity.player.levelup");
                    if (this.prize.useFireworks()) {
                        MiscUtils.spawnFirework(WonderCrate.this.player.getLocation().add(0.0, 1.0, 0.0), null);
                    }
                    WonderCrate.this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerPrizeEvent(WonderCrate.this.player, WonderCrate.this.crate, this.prize));
                    WonderCrate.this.crateManager.removePlayerFromOpeningList(WonderCrate.this.player);
                    return;
                }
                ++this.full;
                ++this.time;
                if (this.time > 2) {
                    this.time = 0;
                }
            }
        }.runAtFixedRate(this.plugin, 0L, 2L));
    }
}

