/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.crates.types;

import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.CrateBuilder;
import com.badbones69.crazycrates.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.UUID;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import net.kyori.adventure.sound.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class RouletteCrate
extends CrateBuilder {
    private final Inventory inventory = this.getInventory();
    private final Player player = this.getPlayer();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();

    public RouletteCrate(@NotNull Crate crate, @NotNull Player player, int size) {
        super(crate, player, size);
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        final String fileName = this.crate.getFileName();
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        this.setItem(13, this.crate.pickPrize(this.player).getDisplayItem(this.player, this.crate));
        this.addCrateTask(new FoliaRunnable(this.player.getScheduler(), null){
            int full;
            int time;
            int even;
            int open;
            {
                super(arg0, arg1);
                this.full = 0;
                this.time = 1;
                this.even = 0;
                this.open = 0;
            }

            @Override
            public void run() {
                if (this.full <= 15) {
                    RouletteCrate.this.setItem(13, RouletteCrate.this.crate.pickPrize(RouletteCrate.this.player).getDisplayItem(RouletteCrate.this.player, RouletteCrate.this.crate));
                    RouletteCrate.this.setGlass();
                    if (this.full >= 2) {
                        RouletteCrate.this.playSound("cycle-sound", Sound.Source.PLAYER, "block.note_block.xylophone");
                    }
                    ++this.even;
                    if (this.even >= 4) {
                        this.even = 0;
                        RouletteCrate.this.setItem(13, RouletteCrate.this.crate.pickPrize(RouletteCrate.this.player).getDisplayItem(RouletteCrate.this.player, RouletteCrate.this.crate));
                    }
                }
                ++this.open;
                if (this.open >= 5) {
                    RouletteCrate.this.player.openInventory(RouletteCrate.this.inventory);
                    this.open = 0;
                }
                ++this.full;
                if (this.full > 16) {
                    if (MiscUtils.slowSpin(46, 9).contains(this.time)) {
                        RouletteCrate.this.setGlass();
                        RouletteCrate.this.setItem(13, RouletteCrate.this.crate.pickPrize(RouletteCrate.this.player).getDisplayItem(RouletteCrate.this.player, RouletteCrate.this.crate));
                        RouletteCrate.this.playSound("cycle-sound", Sound.Source.PLAYER, "block.note_block.xylophone");
                    }
                    ++this.time;
                    if (this.time >= 23) {
                        RouletteCrate.this.playSound("stop-sound", Sound.Source.PLAYER, "entity.player.levelup");
                        RouletteCrate.this.crateManager.endCrate(RouletteCrate.this.player);
                        ItemStack item = RouletteCrate.this.inventory.getItem(13);
                        if (item != null) {
                            Prize prize = RouletteCrate.this.crate.getPrize(item);
                            if (RouletteCrate.this.crate.isCyclePrize() && !PrizeManager.isCapped(RouletteCrate.this.crate, RouletteCrate.this.player)) {
                                new CrateSpinMenu(RouletteCrate.this.player, new GuiSettings(RouletteCrate.this.crate, prize, Files.respin_gui.getConfiguration())).open();
                                RouletteCrate.this.crateManager.removePlayerFromOpeningList(RouletteCrate.this.player);
                                return;
                            }
                            RouletteCrate.this.userManager.removeRespinPrize(RouletteCrate.this.uuid, fileName);
                            if (!RouletteCrate.this.crate.isCyclePersistRestart()) {
                                RouletteCrate.this.userManager.removeRespinCrate(RouletteCrate.this.uuid, fileName, RouletteCrate.this.userManager.getCrateRespin(RouletteCrate.this.uuid, fileName));
                            }
                            PrizeManager.givePrize(RouletteCrate.this.player, RouletteCrate.this.crate, prize);
                        }
                        RouletteCrate.this.crateManager.removePlayerFromOpeningList(RouletteCrate.this.player);
                        new FoliaRunnable(RouletteCrate.this.player.getScheduler(), null){

                            @Override
                            public void run() {
                                if (RouletteCrate.this.player.getOpenInventory().getTopInventory().equals((Object)RouletteCrate.this.inventory)) {
                                    RouletteCrate.this.player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                                }
                            }
                        }.runDelayed(RouletteCrate.this.plugin, 40L);
                    }
                }
            }
        }.runAtFixedRate(this.plugin, 2L, 2L));
    }

    private void setGlass() {
        for (int slot = 0; slot < this.getSize(); ++slot) {
            if (slot == 13) continue;
            this.setCustomGlassPane(slot);
        }
    }
}

