/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.crates.types;

import com.badbones69.crazycrates.api.ChestManager;
import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.CrateBuilder;
import com.badbones69.crazycrates.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.api.enums.Messages;
import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.api.enums.misc.Keys;
import com.badbones69.crazycrates.api.events.PlayerPrizeEvent;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.common.config.ConfigManager;
import com.badbones69.crazycrates.common.config.impl.ConfigKeys;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.support.holograms.HologramManager;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import libs.com.ryderbelserion.vital.paper.util.AdvUtil;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class QuickCrate
extends CrateBuilder {
    private final PluginManager server;
    private final Player player;
    private final Location location;
    private final UUID uuid;
    private final Crate crate;

    public QuickCrate(@NotNull Crate crate, @NotNull Player player, @NotNull Location location) {
        super(crate, player, location);
        this.server = this.plugin.getServer().getPluginManager();
        this.player = this.getPlayer();
        this.location = this.getLocation();
        this.uuid = this.player.getUniqueId();
        this.crate = this.getCrate();
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        int keys;
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        String fileName = this.crate.getFileName();
        switch (type) {
            case virtual_key: {
                int n = this.userManager.getVirtualKeys(this.uuid, fileName);
                break;
            }
            case physical_key: {
                int n = this.userManager.getPhysicalKeys(this.uuid, fileName);
                break;
            }
            default: {
                int n = keys = 1;
            }
        }
        if (this.crate.useRequiredKeys() && keys < this.crate.getRequiredKeys()) {
            final int finalKeys = keys;
            Messages.not_enough_keys.sendMessage((CommandSender)this.player, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{required_amount}", String.valueOf(QuickCrate.this.crate.getRequiredKeys()));
                    this.put("{key_amount}", String.valueOf(QuickCrate.this.crate.getRequiredKeys()));
                    this.put("{amount}", String.valueOf(finalKeys));
                    this.put("{crate}", QuickCrate.this.crate.getCrateName());
                    this.put("{key}", QuickCrate.this.crate.getKeyName());
                }
            });
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        this.crateManager.addCrateInUse(this.player, this.location);
        if (this.player.isSneaking() && keys > 1) {
            int used;
            for (used = 0; keys > 0 && !MiscUtils.isInventoryFull(this.player) && used < this.crate.getMaxMassOpen(); ++used, --keys) {
                Prize prize = this.crate.pickPrize(this.player);
                PrizeManager.givePrize(this.player, prize, this.crate);
                this.server.callEvent((Event)new PlayerPrizeEvent(this.player, this.crate, prize));
                if (!prize.useFireworks()) continue;
                MiscUtils.spawnFirework(this.location.clone().add(0.5, 1.0, 0.5), null);
            }
            boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, used, false);
            if (!keyCheck) {
                MiscUtils.failedToTakeKey((CommandSender)this.player, fileName);
                this.crateManager.removePlayerFromOpeningList(this.player);
                this.crateManager.removeCrateInUse(this.player);
                return;
            }
            this.crateManager.endQuickCrate(this.player, this.location, this.crate, true);
            return;
        }
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, true);
        if (!keyCheck) {
            MiscUtils.failedToTakeKey((CommandSender)this.player, fileName);
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removeCrateInUse(this.player);
            return;
        }
        Prize prize = this.crate.pickPrize(this.player, this.location.clone().add(0.5, 1.3, 0.5));
        if (this.crate.isCyclePrize() && !PrizeManager.isCapped(this.crate, this.player)) {
            new CrateSpinMenu(this.player, new GuiSettings(this.crate, prize, Files.respin_gui.getConfiguration())).open();
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removeCrateInUse(this.player);
            return;
        }
        this.userManager.removeRespinPrize(this.uuid, fileName);
        if (!this.crate.isCyclePersistRestart()) {
            this.userManager.removeRespinCrate(this.uuid, fileName, this.userManager.getCrateRespin(this.uuid, fileName));
        }
        PrizeManager.givePrize(this.player, this.crate, prize);
        this.server.callEvent((Event)new PlayerPrizeEvent(this.player, this.crate, prize));
        boolean showQuickCrateItem = ConfigManager.getConfig().getProperty(ConfigKeys.show_quickcrate_item);
        if (showQuickCrateItem) {
            Item reward;
            CrateLocation crateLocation;
            HologramManager manager = this.crateManager.getHolograms();
            if (manager != null && this.crate.getHologram().isEnabled() && (crateLocation = this.crateManager.getCrateLocation(this.location)) != null) {
                manager.removeHologram(crateLocation.getID());
            }
            ItemStack display = prize.getDisplayItem(this.player, this.crate);
            display.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().set(Keys.crate_prize.getNamespacedKey(), PersistentDataType.STRING, (Object)"1"));
            try {
                reward = this.player.getWorld().dropItem(this.location.clone().add(0.5, 1.0, 0.5), display);
            }
            catch (IllegalArgumentException exception) {
                if (MiscUtils.isLogging()) {
                    ComponentLogger logger = this.plugin.getComponentLogger();
                    logger.warn("A prize could not be given due to an invalid display item for this prize.");
                    logger.warn("Crate: {} Prize: {}", new Object[]{prize.getCrateName(), prize.getPrizeName(), exception});
                }
                return;
            }
            reward.setVelocity(new Vector(0.0, 0.2, 0.0));
            reward.customName(AdvUtil.parse(prize.getPrizeName()));
            reward.setCustomNameVisible(true);
            reward.setCanMobPickup(false);
            reward.setCanPlayerPickup(false);
            this.crateManager.addReward(this.player, (Entity)reward);
            ChestManager.openChest(this.location.getBlock(), true);
            if (prize.useFireworks()) {
                MiscUtils.spawnFirework(this.location.clone().add(0.5, 1.0, 0.5), null);
            }
            this.addCrateTask(new FoliaRunnable(this.player.getScheduler(), null){

                @Override
                public void run() {
                    QuickCrate.this.crateManager.endQuickCrate(QuickCrate.this.player, QuickCrate.this.location, QuickCrate.this.crate, false);
                }
            }.runDelayed(this.plugin, 100L));
            return;
        }
        ChestManager.openChest(this.location.getBlock(), true);
        if (prize.useFireworks()) {
            MiscUtils.spawnFirework(this.location.clone().add(0.5, 1.0, 0.5), null);
        }
        this.addCrateTask(new FoliaRunnable(this.player.getScheduler(), null){

            @Override
            public void run() {
                QuickCrate.this.crateManager.endQuickCrate(QuickCrate.this.player, QuickCrate.this.location, QuickCrate.this.crate, false);
            }
        }.runDelayed(this.plugin, 40L));
    }
}

