/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.crates.types;

import com.badbones69.crazycrates.api.builders.CrateBuilder;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.support.holograms.HologramManager;
import com.badbones69.crazycrates.tasks.crates.types.QuickCrate;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import libs.com.ryderbelserion.vital.paper.util.scheduler.FoliaRunnable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class FireCrackerCrate
extends CrateBuilder {
    private final Player player = this.getPlayer();
    private final Location location = this.getLocation();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();

    public FireCrackerCrate(@NotNull Crate crate, @NotNull Player player, int size, @NotNull Location location) {
        super(crate, player, size, location);
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, final boolean isSilent, final EventType eventType) {
        CrateLocation crateLocation;
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        String fileName = this.crate.getFileName();
        this.crateManager.addCrateInUse(this.player, this.location);
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        HologramManager manager = this.crateManager.getHolograms();
        if (manager != null && this.crate.getHologram().isEnabled() && (crateLocation = this.crateManager.getCrateLocation(this.location)) != null) {
            manager.removeHologram(crateLocation.getID());
        }
        final List<Color> colors = Arrays.asList(Color.RED, Color.YELLOW, Color.GREEN, Color.BLUE, Color.BLACK, Color.AQUA, Color.MAROON, Color.PURPLE);
        this.addCrateTask(new FoliaRunnable(this.player.getScheduler(), null){
            final int random;
            final Location clonedLocation;
            int length;
            {
                super(arg0, arg1);
                this.random = ThreadLocalRandom.current().nextInt(colors.size());
                this.clonedLocation = FireCrackerCrate.this.location.clone().add(0.5, 25.0, 0.5);
                this.length = 0;
            }

            @Override
            public void run() {
                this.clonedLocation.subtract(0.0, 1.0, 0.0);
                MiscUtils.spawnFirework(this.clonedLocation, (Color)colors.get(this.random));
                ++this.length;
                if (this.length == 25) {
                    FireCrackerCrate.this.crateManager.endCrate(FireCrackerCrate.this.player);
                    QuickCrate quickCrate = new QuickCrate(FireCrackerCrate.this.crate, FireCrackerCrate.this.player, FireCrackerCrate.this.location);
                    quickCrate.open(KeyType.free_key, false, isSilent, eventType);
                }
            }
        }.runAtFixedRate(this.plugin, 0L, 2L));
    }
}

