/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.tasks.crates.types;

import com.badbones69.crazycrates.api.PrizeManager;
import com.badbones69.crazycrates.api.builders.CrateBuilder;
import com.badbones69.crazycrates.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.api.enums.misc.Files;
import com.badbones69.crazycrates.api.objects.Crate;
import com.badbones69.crazycrates.api.objects.Prize;
import com.badbones69.crazycrates.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.managers.events.enums.EventType;
import com.badbones69.crazycrates.utils.MiscUtils;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateOnTheGo
extends CrateBuilder {
    private final Player player = this.getPlayer();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();

    public CrateOnTheGo(@NotNull Crate crate, @NotNull Player player) {
        super(crate, player);
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        String fileName = this.crate.getFileName();
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, KeyType.physical_key, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, true);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        Prize prize = this.crate.pickPrize(this.player);
        if (this.crate.isCyclePrize() && !PrizeManager.isCapped(this.crate, this.player)) {
            new CrateSpinMenu(this.player, new GuiSettings(this.crate, prize, Files.respin_gui.getConfiguration())).open();
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removePlayerKeyType(this.player);
            return;
        }
        this.userManager.removeRespinPrize(this.uuid, fileName);
        if (!this.crate.isCyclePersistRestart()) {
            this.userManager.removeRespinCrate(this.uuid, fileName, this.userManager.getCrateRespin(this.uuid, fileName));
        }
        PrizeManager.givePrize(this.player, this.crate, prize);
        if (prize.useFireworks()) {
            MiscUtils.spawnFirework(this.player.getLocation().add(0.0, 1.0, 0.0), null);
        }
        this.crateManager.removePlayerKeyType(this.player);
    }
}

